% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\docType{class}
\name{BioFormatsImage}
\alias{BioFormatsImage}
\alias{BioFormatsImage-class}
\alias{show,BioFormatsImage-method}
\title{On disk representation of BioFormats images in SFE object}
\usage{
\S4method{show}{BioFormatsImage}(object)

BioFormatsImage(
  path,
  ext = NULL,
  isFull = TRUE,
  origin = c(0, 0),
  transformation = list()
)
}
\arguments{
\item{object}{A \code{BioFormatsImage} object.}

\item{path}{Path to an OME-TIFF image file.}

\item{ext}{Numeric vector with names "xmin", "xmax", "ymin", "ymax" in
microns indicating the spatial extent covered by the image. If \code{NULL},
then the extent will be inferred from the metadata, from physical pixel
size and the number of pixels.}

\item{isFull}{Logical, if the extent specified in \code{ext} is the full
extent. If \code{ext = NULL} so it will be inferred from metadata then
\code{isFull = TRUE} will be set internally.}

\item{origin}{Origin of the whole image in the x-y plane, defaults to
\code{c(0,0)}. This is shifted when the image is translated. This is not
the same as xmin and xmax. For example, when the extent is only part of the
whole image and the whole image itself can be spatially translated, the
origin is needed to determine which part of the whole image this extent
corresponds to.}

\item{transformation}{Named list specifying affine transformation. The list
can have names "name" and named parameter of the transformation, e.g.
\code{list(name = "mirror", direction = "vertical")}, "rotate" and degrees = 90
(clockwise), and "scale" and factor = 2. The list can also have names "M"
for a 2x2 linear transformation matrix in the xy plane and "v" for a
translation vector of length 2 to specify general affine transformation.}
}
\value{
A \code{BioFormatsImage} object.
}
\description{
`r lifecycle::badge("experimental")` At present, the \code{BioFormatsImage}
is designed for OME-TIFF from Xenium and has not been tested on other formats
that can be read with \code{BioFormats}. The image is not loaded into memory,
and when it is, the the \code{BioFormatsImage} object is converted into
\code{\link{ExtImage}} because the loaded image is of a class that inherits
from \code{\link{Image}}. The \code{\link{ExtImage}} class is a thin wrapper
inheriting from \code{VirtualSpatialImage} so it's compatible with
\code{SpatialExperiment} from which SFE is derived. This class might
drastically change as it matures, say to accommodate other formats supported
by \code{BioFormats} and to store the transformation matrix rather than
loading image into memory upon transform.
}
\details{
Spatial extent is inferred from OME-TIFF metadata if not specified. Physical
pixel size from the metadata is used to make the extent in micron space. If
physical pixel size is absent from metadata, then the extent will be in pixel
space, which might mean that the image will not align with the geometries
because often the geometry coordinates are in microns, so a warning is issued
in this case.

Affine transformations can be specified in the \code{transformation}
argument, either by name or by directly specifying the matrix. The
transformations specified by name will always preserve the center of the
image. When named transformations are chained, name and parameter will be
converted to matrix and translation vector the second time a transformation
is specified. If the subsequent transformation happens to restore the image
to its original place, then transformation specifications will be removed.
}
\seealso{
[isFull()], [origin()]
}
\concept{Image classes}
