% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce.R
\name{SpatialFeatureExperiment-coercion}
\alias{SpatialFeatureExperiment-coercion}
\alias{toSpatialFeatureExperiment}
\alias{toSpatialFeatureExperiment,SpatialExperiment-method}
\alias{toSpatialFeatureExperiment,SingleCellExperiment-method}
\alias{toSpatialFeatureExperiment,Seurat-method}
\title{SpatialFeatureExperiment coercion methods}
\usage{
\S4method{toSpatialFeatureExperiment}{SpatialExperiment}(
  x,
  colGeometries = NULL,
  rowGeometries = NULL,
  annotGeometries = NULL,
  spatialCoordsNames = c("x", "y"),
  annotGeometryType = "POLYGON",
  spatialGraphs = NULL,
  spotDiameter = NA,
  unit = NULL
)

\S4method{toSpatialFeatureExperiment}{SingleCellExperiment}(
  x,
  sample_id = "sample01",
  spatialCoordsNames = c("x", "y"),
  spatialCoords = NULL,
  colGeometries = NULL,
  rowGeometries = NULL,
  annotGeometries = NULL,
  annotGeometryType = "POLYGON",
  spatialGraphs = NULL,
  spotDiameter = NA,
  scaleFactors = 1,
  imageSources = NULL,
  image_id = NULL,
  loadImage = TRUE,
  imgData = NULL,
  unit = NULL
)

\S4method{toSpatialFeatureExperiment}{Seurat}(
  x,
  add_molecules = TRUE,
  flip = c("geometry", "image", "none"),
  image_scalefactors = c("lowres", "hires"),
  unit = NULL,
  BPPARAM = SerialParam()
)
}
\arguments{
\item{x}{A \code{SpatialExperiment} or \code{Seurat} object to be coerced to a
\code{SpatialFeatureExperiment} object.}

\item{colGeometries}{Geometry of the entities that correspond to the columns
of the gene count matrix, such as cells and Visium spots. It must be a
named list of one of the following: \describe{ \item{An \code{sf} data
frame}{The geometry column specifies the geometry of the entities.}
\item{An ordinary data frame specifying centroids}{Column names for the
coordinates are specified in the \code{spatialCoordsNames} argument. For
Visium and ST, in addition to the centroid coordinate data frame, the spot
diameter in the same unit as the coordinates can be specified in the
\code{spotDiamter} argument.} \item{An ordinary data frame specifying
polygons}{Also use \code{spatialCoordsNames}. There should an additional
column "ID" to specify which vertices belong to which polygon. The
coordinates should not be in list columns. Rather, the data frame should
look like it is passed to \code{ggplot2::geom_polygon}. If there are holes,
then there must also be a column "subID" that differentiates between the
outer polygon and the holes.}} In all cases, the data frame should specify
the same number of geometries as the number of columns in the gene count
matrix. If the column "barcode" is present, then it will be matched to
column names of the gene count matrix. Otherwise, the geometries are
assumed to be in the same order as columns in the gene count matrix. If the
geometries are specified in an ordinary data frame, then it will be
converted into \code{sf} internally. Named list of data frames because each
entity can have multiple geometries, such as whole cell and nuclei
segmentations. The geometries are assumed to be POINTs for centroids and
POLYGONs for segmentations. If polygons are specified in an ordinary data
frame, then anything with fewer than 3 vertices will be removed. For
anything other than POINTs, attributes of the geometry will be ignored.}

\item{rowGeometries}{Geometry associated with genes or features, which
correspond to rows of the gene count matrix.}

\item{annotGeometries}{Geometry of entities that do not correspond to columns
or rows of the gene count matrix, such as tissue boundary and pathologist
annotations of histological regions, and nuclei segmentation in a Visium
dataset. Also a named list as in \code{colGeometries}. The ordinary data
frame may specify POINTs, POLYGONs, or LINESTRINGs, or their MULTI
versions. Each data frame can only specify one type of geometry. For MULTI
versions, there must be a column "group" to identify each MULTI geometry.}

\item{spatialCoordsNames}{A \code{character} vector of column names if
\code{*Geometries} arguments have ordinary data frames, to identify the
columns in the ordinary data frames that specify the spatial coordinates.
If \code{colGeometries} is not specified, then this argument will behave as
in \code{\link{SpatialExperiment}}, but \code{colGeometries} will be given
precedence if provided.}

\item{annotGeometryType}{Character vector specifying geometry type of each
element of the list if \code{annotGeometry} is specified. Each element of
the vector must be one of POINT, LINESTRING, POLYGON, MULTIPOINT,
MULTILINESTRING, and MULTIPOLYGON. Must be either length 1 (same for all
elements of the list) or the same length as the list. Ignored if the
corresponding element is an \code{sf} object.}

\item{spatialGraphs}{A named list of \code{listw} objects (see \code{spdep})
for spatial neighborhood graphs.}

\item{spotDiameter}{Spot diameter for technologies with arrays of spots of
fixed diameter per slide, such as Visium, ST, DBiT-seq, and slide-seq. The
diameter must be in the same unit as the coordinates in the *Geometry
arguments. Ignored for geometries that are not POINT or MULTIPOINT.}

\item{unit}{# Default unit is \code{"micron"}. However for Visium one can choose
between \code{"micron"} or \code{"full_res_image_pixel"}.}

\item{sample_id}{A \code{character} sample identifier, which matches the
\code{sample_id} in \code{\link[SpatialExperiment]{imgData}}. The \code{sample_id} will also
be stored in a new column in \code{\link[SpatialExperiment]{colData}}, if not already present.
Default = \code{sample01}.}

\item{spatialCoords}{A numeric matrix containing columns of spatial
coordinates, as in \code{\link{SpatialExperiment}}. The coordinates are
centroids of the entities represented by the columns of the gene count
matrix. If \code{colGeometries} is also specified, then it will be given
priority and a warning is issued. Otherwise, the \code{sf} representation
of the centroids will be stored in the \code{colGeometry} called
\code{centroids}.}

\item{scaleFactors}{Optional scale factors associated with the image(s). This
can be provided as a numeric value, numeric vector, list, or file path to a
JSON file for the 10x Genomics Visium platform. For 10x Genomics Visium,
the correct scale factor will automatically be selected depending on the
resolution of the image from \code{imageSources}. Default = \code{1}.}

\item{imageSources}{Optional file path(s) or URL(s) for one or more image
sources.}

\item{image_id}{Optional character vector (same length as
\code{imageSources}) containing unique image identifiers.}

\item{loadImage}{Logical indicating whether to load image into memory.
Default = \code{FALSE}.}

\item{imgData}{Optional \code{\link{DataFrame}} containing the image data.
Alternatively, this can be built from the arguments \code{imageSources} and
\code{image_id} (see Details).}

\item{add_molecules}{Logical, whether to add transcripts coordinates to an
object.}

\item{flip}{To flip the image, geometry coordinates, or none. Because the
image has the origin at the top left while the geometry has origin at the
bottom left, one of them needs to be flipped for them to match. If one of
them is already flipped, then use "none". The image will not be flipped if
it's GeoTIFF.}

\item{image_scalefactors}{# A \code{character}, choose between "lowres" or "hires".
Only for 10X Visium, image scaling factors are from `scalefactors_json.json` file.}

\item{BPPARAM}{Deprecated when coercing from \code{SpatialExperiment},
but is used when coercing from \code{Seurat} object.}
}
\value{
A \code{SpatialFeatureExperiment} object
}
\description{
The \code{SpatialFeatureExperiment} class inherits from
\code{SpatialExperiment}, which in turn inherits from
\code{SingleCellExperiment}. A \code{SpatialExperiment} object with
geometries in \code{colGeometries} in the \code{int_colData},
\code{rowGeometries} in the \code{int_elementMetadata}, or
\code{annotGeometries} in the \code{int_metadata} can be directly converted
to \code{SpatialFeatureExperiment} with \code{as(spe,
"SpatialFeatureExperiment")}. A \code{SpatialExperiment} object without the
geometries can also be converted; the coordinates in the \code{spatialCoords}
field will be used to make POINT geometries named "centroids" to add to
\code{colGeometries}. The geometries can also be supplied separately when
using \code{toSpatialFeatureExperiment}. Images are converted to \code{SpatRaster}.
}
\examples{
library(SpatialExperiment)
example(read10xVisium)
# There can't be duplicate barcodes
colnames(spe) <- make.unique(colnames(spe), sep = "-")
rownames(spatialCoords(spe)) <- colnames(spe)
sfe <- toSpatialFeatureExperiment(spe)
# For coercing Seurat to SFE see this -> ./vignettes/seurat_sfe_coerce.Rmd
}
\concept{SpatialFeatureExperiment class}
