% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{SpatialFeatureExperiment-subset}
\alias{SpatialFeatureExperiment-subset}
\alias{[,SpatialFeatureExperiment,ANY,ANY,ANY-method}
\title{Subsetting SpatialFeatureExperiment objects}
\usage{
\S4method{[}{SpatialFeatureExperiment,ANY,ANY,ANY}(x, i, j, ..., drop = FALSE)
}
\arguments{
\item{x}{A \code{SpatialFeatureExperiment} object.}

\item{i}{Row indices for subsetting.}

\item{j}{column indices for subsetting.}

\item{...}{Passed to the \code{SingleCellExperiment} method of \code{[}.}

\item{drop}{Ignored as of version 1.9.2.}
}
\value{
A subsetted \code{SpatialFeatureExperiment} object.
}
\description{
Note that spatial neighborhood graphs may change meaning after subsetting.
For example, for a k nearest neighbor graph, after subsetting, some cells
might no longer have all k nearest neighbors from the original
}
\examples{
# Just like subsetting matrices and SingleCellExperiment
library(SFEData)
sfe <- McKellarMuscleData(dataset = "small")
sfe_subset <- sfe[seq_len(10), seq_len(10), drop = TRUE]
# Gives warning as graph reconstruction fails
\donttest{
sfe_subset <- sfe[seq_len(10), seq_len(10)]
}
}
\concept{Non-spatial operations}
