% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{affineImg}
\alias{affineImg}
\alias{affineImg,SpatRasterImage-method}
\alias{affineImg,BioFormatsImage-method}
\alias{affineImg,ExtImage-method}
\title{Affine transformation of images}
\usage{
\S4method{affineImg}{SpatRasterImage}(x, M, v, maxcell = 1e+07, ...)

\S4method{affineImg}{BioFormatsImage}(x, M, v, ...)

\S4method{affineImg}{ExtImage}(x, M, v, ...)
}
\arguments{
\item{x}{An object of class \code{*Image} as implemented in this package.}

\item{M}{A 2x2 numeric matrix for the linear transformation in the xy plane.}

\item{v}{A numeric vector of length 2 for translation in the xy plane.}

\item{maxcell}{Max number of pixels to load \code{SpatRasterImage} into
memory. The default 1e7 is chosen because this is the approximate number of
pixels in the medium resolution image at \code{resolution = 4L} in Xenium
OME-TIFF to make different methods of this function consistent.}

\item{...}{Ignored. It's there so different methods can all be passed to the
same \code{lapply} in the method for SFE objects. Some methods have extra
arguments.}
}
\value{
\code{SpatRasterImage} will be converted to \code{ExtImage}. Otherwise
\code{*Image} object of the same class. For \code{BioFormatsImage}, the
transformation info is stored and will be applied when the image is loaded
into memory as \code{ExtImage}.
}
\description{
This function performs affine transformation on images, with any matrix and
translation vector.
}
\seealso{
Other image methods: 
\code{\link{SFE-image}},
\code{\link{cropImg}()},
\code{\link{dim,BioFormatsImage-method}},
\code{\link{ext}()},
\code{\link{imgRaster}()},
\code{\link{imgSource}()},
\code{\link{mirrorImg}()},
\code{\link{rotateImg}()},
\code{\link{scaleImg}()},
\code{\link{translateImg}()},
\code{\link{transposeImg}()}
}
\concept{Image affine transformation}
\concept{image methods}
