% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{aggregate,SpatialFeatureExperiment-method}
\alias{aggregate,SpatialFeatureExperiment-method}
\title{Aggregate data in SFE using geometry}
\usage{
\S4method{aggregate}{SpatialFeatureExperiment}(
  x,
  by = NULL,
  FUN = sum,
  sample_id = "all",
  colGeometryName = 1L,
  rowGeometryName = NULL,
  cellsize = NULL,
  square = TRUE,
  flat_topped = FALSE,
  new_geometry_name = "bins",
  join = st_intersects,
  BPPARAM = SerialParam()
)
}
\arguments{
\item{x}{An SFE object to be aggregated.}

\item{by}{A \code{sf} data frame whose geometry column is used for
aggregation or \code{sfc} or for multiple samples a list of \code{sfc}
whose names are the sample IDs. For multiple samples, the \code{sf} data
frame must have a column \code{sample_id} to indicate which geometry for
which sample. This argument is optional if \code{cellsize} is specified.}

\item{FUN}{Function to aggregate the numerical columns in \code{colData} and
the gene count matrix. This can be \code{sum}, \code{mean}, or any function
that takes a numeric matrix as input and returns a numeric vector whose
length is same as the number of rows in the input matrix, such as
\code{rowMedians}. See package \code{matrixStats}. Depending on the
function used for aggregation, numeric columns of \code{colData} may need
to be interpreted differently after aggregation. Aggregation is not done
when aggregating by transcript spots in \code{rowGeometry}. When it's sum
or mean, matrix multiplication is used for aggregation rather than calling
the sum or mean function itself; this is much faster than looping through
the bins and calling the function on each of them.}

\item{sample_id}{Which samples to aggregate, defaults to "all".}

\item{colGeometryName}{Which \code{colGeometry} to spatially aggregate the
data, by default the first one.}

\item{rowGeometryName}{Which \code{rowGeometry} to spatially aggregate}

\item{cellsize}{numeric of length 1 or 2 with target cellsize: for square or rectangular cells the width and height, for hexagonal cells the distance between opposite edges (edge length is cellsize/sqrt(3)). A length units object can be passed, or an area unit object with area size of the square or hexagonal cell.}

\item{square}{logical; if \code{FALSE}, create hexagonal grid}

\item{flat_topped}{logical; if \code{TRUE} generate flat topped hexagons, else generate pointy topped}

\item{new_geometry_name}{Name to give to the new \code{colGeometry} in the
output. Defaults to "bins".}

\item{join}{logical spatial predicate function to use if \code{by} is a simple features object or geometry; see \link[sf]{st_join}}

\item{BPPARAM}{A \code{\link{BiocParallelParam}} object specifying parallel
computing when aggregating data with functions other than sum and mean.
Defaults to \code{SerialParam()}.}
}
\value{
An SFE object with \code{colGeometry} the same as the geometry
  specified in \code{by} or same as the grid specified in \code{cellsize}.
  \code{rowGeometries} and \code{rowData} remain the same as in the input
  \code{x}. \code{reducedDims}, \code{localResults}, \code{colFeatureData}
  (and its \code{colGeometry}, \code{annotGeometry}, and \code{reducedDim}
  counterparts), and \code{spatialGraphs} are dropped because those results
  no longer apply after aggregation.
}
\description{
Gene expression and numeric columns of \code{colData} will be aggregated with
the function specified in \code{FUN}, according to another geometry supplied
and a geometry predicate (such as \code{st_intersects}). For example, when
the predicate is \code{st_intersects} and a spatial grid is used to
aggregate, then the data associated with all cells that intersect with each
grid cell will be aggregated with \code{FUN}, such as \code{mean} or
\code{sum}. The categorical columns will be collected into list columns, and
logical columns will be converted into numeric before applying \code{FUN}.
}
\details{
For smFISH-based data where the transcript spots are available, the
transcript spots can be used instead of cells to aggregate the gene count
matrix, in which case all assays other than \code{counts} will be dropped and
\code{FUN} only applies to \code{colData} because the transcript spots are
simply counted.

What this function does is similar to
\href{https://github.com/JEFworks-Lab/SEraster}{SEraster} but more general
because any geometry and more aggregation function can be used, not just
regular grids, and the aggregation can be performed on the transcript spots.
}
\note{
For developers: When debugging this function after calling
  \code{devtools::load_all(".")}, you may get an error that comes from S3
  dispatch of \code{aggregate.Vector} from the \code{S4Vectors} package. When
  that happens, either restart the R session, or run
  \code{setGeneric("aggregate", function(x, ...)
  standardGeneric("aggregate"))} in the console to make an S4 generic as done
  in the \code{terra} package to prioritize S4 dispatch.
}
\examples{
# example code

}
\concept{Geometric operations}
