% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry_operation.R
\name{annotSummary}
\alias{annotSummary}
\title{Summarize attributes of an annotGeometry for each cell/spot}
\usage{
annotSummary(
  sfe,
  colGeometryName = 1L,
  annotGeometryName = 1L,
  annotColNames = 1L,
  sample_id = "all",
  pred = st_intersects,
  summary_fun = mean
)
}
\arguments{
\item{sfe}{An SFE object.}

\item{colGeometryName}{Name of column geometry for the predicate.}

\item{annotGeometryName}{Name of annotation geometry for the predicate.}

\item{annotColNames}{Character, column names of the \code{annotGeometry} of
interest, to indicate the columns to summarize. Columns that are absent
from the \code{annotGeometry} are removed. The column cannot be "geometry"
or "barcode".}

\item{sample_id}{Which sample(s) to operate on. Can be "all" to indicate all
samples.}

\item{pred}{Predicate function to use, defaults to
\code{\link{st_intersects}}.}

\item{summary_fun}{Function for the summary, defaults to \code{mean}.}
}
\value{
A data frame whose row names are the relevant column names of
  \code{sfe}, and each column of which is the summary of each column
  specified in \code{annotColName}.
}
\description{
In SFE objects, the annotation geometries don't have to correspond to the
dimensions of the gene count matrix, so there generally is no one to one
mapping between annotation geometries and cells/spots. However, it may be
interesting to relate attributes of annotation geometries to cell/spots so
the attributes can be related to gene expression. This function summarizes
attributes of an \code{annotGeometry} for each cell/spot by a geometric
predicate with a \code{colGeometry}.
}
\examples{
library(SFEData)
sfe <- McKellarMuscleData("small")
s <- annotSummary(sfe, "spotPoly", "myofiber_simplified",
    annotColNames = c("area", "convexity")
)
}
\concept{Geometric operations}
