% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_wrappers.R
\name{findSpatialNeighbors,SpatialFeatureExperiment-method}
\alias{findSpatialNeighbors,SpatialFeatureExperiment-method}
\alias{findSpatialNeighbors}
\title{Find spatial neighborhood graph}
\usage{
\S4method{findSpatialNeighbors}{SpatialFeatureExperiment}(
  x,
  sample_id = "all",
  type = "spatialCoords",
  MARGIN = 2,
  method = c("tri2nb", "knearneigh", "dnearneigh", "gabrielneigh", "relativeneigh",
    "soi.graph", "poly2nb"),
  dist_type = c("none", "idw", "exp", "dpd"),
  glist = NULL,
  style = c("raw", "W", "B", "C", "U", "minmax", "S"),
  nn_method = c("bioc", "spdep"),
  alpha = 1,
  dmax = NULL,
  BPPARAM = SerialParam(),
  BNPARAM = KmknnParam(),
  zero.policy = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{\link{SpatialFeatureExperiment}} object.}

\item{sample_id}{Which sample(s) in the SFE object to use for the graph. Can
also be "all", which means this function will compute the graph for all
samples independently.}

\item{type}{Name of the geometry associated with the MARGIN of interest for
which to compute the graph.}

\item{MARGIN}{Just like in \code{\link{apply}}, where 1 stands for row, 2
stands for column. Here, in addition, 3 stands for annotation, to query the
\code{\link{annotGeometries}}, such as nuclei segmentation in a Visium data}

\item{method}{Name of function in the package \code{spdep} to use to find the
spatial neighborhood graph.}

\item{dist_type}{Type of distance-based weight. "none" means not using
distance-based weights; the edge weights of the spatial neighborhood graph
will be entirely determined by the \code{style} argument. "idw" means
inverse distance weighting. "exp" means exponential decay. "dpd" means
double-power distance weights. See \code{\link[spdep]{nb2listwdist}} for
details.}

\item{glist}{list of general weights corresponding to neighbours}

\item{style}{\code{style} can take values \dQuote{W}, \dQuote{B}, \dQuote{C}, \dQuote{U}, \dQuote{minmax} and \dQuote{S}}

\item{nn_method}{Method to find k nearest neighbors and distance based
neighbors. Can be either "bioc" or "spdep". For "bioc", methods from
\code{BiocNeighbors} are used. For "spdep", methods from the \code{spdep}
package are used. The "bioc" option is more scalable to larger datasets and
supports multithreading.}

\item{alpha}{Only relevant when \code{dist_type = "dpd"}.}

\item{dmax}{Only relevant when \code{dist_type = "dpd"}.}

\item{BPPARAM}{A \code{\link{BiocParallelParam}} object for multithreading.
Only used for k nearest neighbor and distance based neighbor with
\code{nn_method = "bioc"}.}

\item{BNPARAM}{A \code{\link{BiocNeighborParam}} object specifying the
algorithm to find k nearest neighbors and distance based neighbors with
\code{nn_method = "bioc"}. For distance based neighbors, only
\code{\link{KmknnParam}} and \code{\link{VptreeParam}} are applicable.}

\item{zero.policy}{default NULL, use global option value; if FALSE stop with error for any empty neighbour sets, if TRUE permit the weights list to be formed with zero-length weights vectors}

\item{...}{Extra arguments passed to the \code{spdep} function stated in the
\code{method} argument, such as \code{k}, \code{use_kd_tree}, \code{d1},
\code{d2}, \code{nnmult}, \code{sym}, and \code{quadsegs}. Note that any
arguments about using longitude and latitude, which are irrelevant, are
ignored.}
}
\value{
For one sample, then a \code{listw} object representing the graph,
  with an attribute "method" recording the function used to build the graph,
  its arguments, and information about the geometry for which the graph was
  built. The attribute is used to reconstruct the graphs when the SFE object
  is subsetted since some nodes in the graph will no longer be present. If
  sample_id = "all" or has length > 1, then a named list of \code{listw}
  objects, whose names are the sample_ids. To add the list for multiple
  samples to a SFE object, specify the \code{name} argument in the
  \code{\link{spatialGraphs}} replacement method, so graph of the same name
  will be added to the SFE object for each sample.
}
\description{
This function wraps all spatial neighborhood graphs implemented in the
package \code{spdep} for the \code{SpatialFeatureExperiment} (SFE) class, to
find spatial neighborhood graphs for the entities represented by columns or
rows of the gene count matrix in the SFE object or spatial entities in the
\code{annotGeometries} field of the SFE object. Results are stored as
\code{listw} objects in the \code{spatialGraphs} field of the SFE object, as
\code{listw} is used in many methods that facilitate the spatial neighborhood
graph in the \code{spdep}, \code{spatialreg}, and \code{adespatial}. The edge
weights of the graph in the \code{listw} object are by default style W (see
\code{\link{nb2listw}}) and the unweighted neighbor list is in the
\code{neighbours} field of the \code{listw} object.
}
\note{
\code{style = "raw"} is only applicable when \code{dist_type} is not
  "none". If \code{dist_type = "none"} and \code{style = "raw"}, then style
  will default to "W". Using distance based weights does not supplant finding
  a spatial neighborhood graph. The spatial neighborhood graph is first found
  and then its edges weighted based on distance in this function.
}
\examples{
library(SFEData)
sfe <- McKellarMuscleData(dataset = "small")
# sample_id is optional when only one sample is present
g <- findSpatialNeighbors(sfe, sample_id = "Vis5A")
attr(g, "method")
# Returns named list for multiple samples
sfe2 <- McKellarMuscleData(dataset = "small2")
sfe_combined <- cbind(sfe, sfe2)
gs <- findSpatialNeighbors(sfe, sample_id = "all")
}
\concept{Spatial neighborhood graph}
