% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_wrappers.R
\name{findVisiumHDGraph}
\alias{findVisiumHDGraph}
\title{Find Visium HD spatial neighborhood graph}
\usage{
findVisiumHDGraph(x, style = "W", queen = FALSE, zero.policy = TRUE)
}
\arguments{
\item{x}{An SFE object with Visium HD data with one sample with the required
information in its \code{colData}.}

\item{style}{\code{style} can take values \dQuote{W}, \dQuote{B}, \dQuote{C}, \dQuote{U}, \dQuote{minmax} and \dQuote{S}}

\item{queen}{Logical. Default is \code{FALSE}, using rook neighbors.}

\item{zero.policy}{default NULL, use global option value; if FALSE stop with error for any empty neighbour sets, if TRUE permit the weights list to be formed with zero-length weights vectors}
}
\value{
A \code{listw} object for the graph.
}
\description{
Visium HD spots are arranged in a square grid. This function finds either a
rook or a queen spatial neighborhood graph for the spots. \code{colData} of
the SFE object must have columns \code{array_row} and \code{array_col}.
}
\concept{Spatial neighborhood graph}
