% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatTxSpots.R
\name{formatTxTech}
\alias{formatTxTech}
\alias{addTxTech}
\title{Read and process transcript spots for specific commercial technologies}
\usage{
formatTxTech(
  data_dir,
  tech = c("Vizgen", "Xenium", "CosMX"),
  dest = c("rowGeometry", "colGeometry"),
  z = "all",
  min_phred = 20,
  split_cell_comps = FALSE,
  z_option = c("3d", "split"),
  flip = FALSE,
  file_out = NULL,
  BPPARAM = SerialParam(),
  return = TRUE
)

addTxTech(
  sfe,
  data_dir,
  sample_id = 1L,
  tech = c("Vizgen", "Xenium", "CosMX"),
  z = "all",
  min_phred = 20,
  split_cell_comps = FALSE,
  z_option = c("3d", "split"),
  flip = FALSE,
  file_out = NULL,
  BPPARAM = SerialParam()
)
}
\arguments{
\item{data_dir}{Top level output directory.}

\item{tech}{Which technology whose output to read, must be one of "Vizgen",
"Xenium", or "CosMX" though more technologies may be added later.}

\item{dest}{Where in the SFE object to store the spot geometries. This
affects how the data is processed. Options: \describe{
\item{rowGeometry}{All spots for each gene will be a `MULTIPOINT` geometry,
regardless of whether they are in cells or which cells they are assigned
to.} \item{colGeometry}{The spots for each gene assigned to a cell of
interest will be a `MULTIPOINT` geometry; since the gene count matrix is
sparse, the geometries are NOT returned to memory.}}}

\item{z}{Which z-planes to read. Always "all" for Xenium where the z
coordinates are not discrete.}

\item{min_phred}{Minimum Phred score to keep spot. By default 20, the
conventional threshold indicating "acceptable", meaning that there's 1%
chance that the spot was decoded in error.}

\item{split_cell_comps}{Only relevant to CosMX whose transcript spot file
assigns the spots to cell components. Setting this argument to \code{TRUE}}

\item{z_option}{What to do with z coordinates. "3d" is to construct 3D
geometries. "split" is to create a separate 2D geometry for each z-plane so
geometric operations are fully supported but some data wrangling is
required to perform 3D analyses. When the z coordinates are not integers,
3D geometries will always be constructed since there are no z-planes to
speak of. This argument does not apply when `spatialCoordsNames` has length
2.}

\item{flip}{Logical, whether to flip the geometry to match image. Here the y
coordinates are simply set to -y, so the original bounding box is not
preserved. This is consistent with \code{readVizgen} and \code{readXenium}.}

\item{file_out}{Name of file to save the geometry or raster to disk.
Especially when the geometries are so large that it's unwieldy to load
everything into memory. If this file (or directory for multiple files)
already exists, then the existing file(s) will be read, skipping the
processing. When writing the file, extensions supplied are ignored and
extensions are determined based on `dest`.}

\item{BPPARAM}{\code{\link{BiocParallelParam}} object to specify
multithreading to convert raw char in some parquet files to R objects. Not
used otherwise.}

\item{return}{Logical, whether to return the geometries in memory. This does
not depend on whether the geometries are written to file. Always `FALSE`
when `dest = "colGeometry"`.}

\item{sfe}{A `SpatialFeatureExperiment` object.}

\item{sample_id}{Which sample in the SFE object the transcript spots should
be added to.}
}
\value{
The `sf` data frame, or path to file where geometries are written if
  `return = FALSE`.
}
\description{
To preset parameters such as \code{spatialCoordsNames}, \code{gene_col},
\code{cell_col}, and \code{phred_col} that are standard for the output of the
technology.
}
\examples{
library(SFEData)
fp <- tempfile()
dir_use <- XeniumOutput("v2", file_path = fp)
fn_tx <- formatTxTech(dir_use, tech = "Xenium", flip = TRUE, return = FALSE,
                      file_out = file.path(dir_use, "tx_spots.parquet"))

}
\concept{Transcript spots}
