% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{imgRaster}
\alias{imgRaster}
\alias{imgRaster,SpatRasterImage-method}
\alias{imgRaster,BioFormatsImage-method}
\alias{imgRaster,ExtImage-method}
\title{Get the image from *Image class}
\arguments{
\item{x}{An object of class \code{*Image} as implemented in this package.}

\item{resolution}{Resolution to read in from OME-TIFF, defaults to 4, which
is a medium resolution in Xenium.}
}
\value{
\code{SpatRaster} from \code{SpatRasterImage}, and \code{Image} from
  \code{ExtImage} and \code{BioFormatsImage}. For \code{BioFormatsImage}, the
  image of the specified resolution will be read into memory as
  \code{AnnotatedImage} and \code{ExtImage}, which both inherit from
  \code{EBImage::Image}.
}
\description{
In SFE, S4 classes inheriting from \code{VirtualSpatialImage} have been
implemented to make these image classes compatible with
\code{SpatialExperiment}. The \code{imgRaster} methods in SFE are meant to
extract the original image from the \code{*Image} classes, such as
\code{SpatRaster} from \code{SpatRasterImage}, and \code{Image} from
\code{ExtImage} and \code{BioFormatsImage}. For \code{BioFormatsImage}, the
image of the specified resolution will be read into memory as
\code{AnnotatedImage}, which inherits from \code{EBImage::Image}.
}
\seealso{
Other image methods: 
\code{\link{SFE-image}},
\code{\link{affineImg}()},
\code{\link{cropImg}()},
\code{\link{dim,BioFormatsImage-method}},
\code{\link{ext}()},
\code{\link{imgSource}()},
\code{\link{mirrorImg}()},
\code{\link{rotateImg}()},
\code{\link{scaleImg}()},
\code{\link{translateImg}()},
\code{\link{transposeImg}()}
}
\concept{Image methods}
\concept{image methods}
