% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listw2sparse.R
\name{listw2sparse}
\alias{listw2sparse}
\title{Convert listw into sparse adjacency matrix}
\usage{
listw2sparse(listw)
}
\arguments{
\item{listw}{A \code{listw} object for spatial neighborhood graph.}
}
\value{
A sparse \code{dgCMatrix}, whose row represents each cell or spot and
  whose columns represent the neighbors. The matrix does not have to be
  symmetric. If \code{region.id} is present in the \code{listw} object, then
  it will be the row and column names of the output matrix.
}
\description{
Edge weights are used in the adjacency matrix. Because most elements of the
matrix are 0, using sparse matrix greatly reduces memory use.
}
\examples{
library(SFEData)
sfe <- McKellarMuscleData("small")
g <- findVisiumGraph(sfe)
mat <- listw2sparse(g)
}
