% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{mirrorImg}
\alias{mirrorImg}
\alias{mirrorImg,SpatRasterImage-method}
\alias{mirrorImg,BioFormatsImage-method}
\alias{mirrorImg,ExtImage-method}
\title{Mirror/flip images}
\usage{
\S4method{mirrorImg}{SpatRasterImage}(
  x,
  direction = c("vertical", "horizontal"),
  filename = "",
  maxcell = NULL,
  ...
)

\S4method{mirrorImg}{BioFormatsImage}(x, direction = c("vertical", "horizontal"), ...)

\S4method{mirrorImg}{ExtImage}(x, direction = c("vertical", "horizontal"), ...)
}
\arguments{
\item{x}{SpatRaster or SpatVector}

\item{direction}{character. Should (partially) match "vertical" to flip by rows, or "horizontal" to flip by columns}

\item{filename}{character. Output filename}

\item{maxcell}{Max number of pixels to load \code{SpatRasterImage} into
memory. The default 1e7 is chosen because this is the approximate number of
pixels in the medium resolution image at \code{resolution = 4L} in Xenium
OME-TIFF to make different methods of this function consistent.}

\item{...}{additional arguments for writing files as in \code{\link[terra]{writeRaster}}}
}
\value{
\code{*Image} object of the same class.
}
\description{
Flip images along the middle horizontal or vertical axis.
}
\seealso{
Other image methods: 
\code{\link{SFE-image}},
\code{\link{affineImg}()},
\code{\link{cropImg}()},
\code{\link{dim,BioFormatsImage-method}},
\code{\link{ext}()},
\code{\link{imgRaster}()},
\code{\link{imgSource}()},
\code{\link{rotateImg}()},
\code{\link{scaleImg}()},
\code{\link{translateImg}()},
\code{\link{transposeImg}()}
}
\concept{Image affine transformation}
\concept{image methods}
