% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read10xVisiumSFE}
\alias{read10xVisiumSFE}
\title{Read 10X Visium data as SpatialFeatureExperiment}
\usage{
read10xVisiumSFE(
  samples = "",
  dirs = file.path(samples, "outs"),
  sample_id = paste0("sample", sprintf("\%02d", seq_along(samples))),
  type = c("HDF5", "sparse"),
  data = c("filtered", "raw"),
  images = c("lowres", "hires"),
  unit = c("full_res_image_pixel", "micron"),
  style = "W",
  zero.policy = NULL,
  load = deprecated(),
  row.names = c("id", "symbol"),
  flip = c("geometry", "image", "none")
)
}
\arguments{
\item{samples}{A character vector containing one or more directory names, each corresponding to a 10X sample.
Each directory should contain a matrix file, a gene/feature annotation file, and a barcode annotation file.

Alternatively, each string may contain a path to a HDF5 file in the sparse matrix format generated by 10X.
These can be mixed with directory names when \code{type="auto"}.

Alternatively, each string may contain a prefix of names for the three-file system described above,
where the rest of the name of each file follows the standard 10X output.}

\item{dirs}{Directory for each sample that contains the \code{spatial} and
\code{raw/filtered_featues_bc_matrix} directories. By default, the
\code{outs} directory under the directory specified in the \code{samples}
argument, as in Space Ranger output. Change the \code{dirs} argument if you
have moved or renamed the output directory.}

\item{sample_id}{Which sample(s) in the SFE object to use for the graph. Can
also be "all", which means this function will compute the graph for all
samples independently.}

\item{type}{Either "HDF5", and the matrix will be represented as
\code{TENxMatrix}, or "sparse", and the matrix will be read as a
\code{dgCMatrix}.}

\item{data}{character string specifying whether to read in
filtered (spots mapped to tissue) or raw data (all spots).}

\item{images}{character vector specifying which images to include. 
Valid values are \code{"lowres", "hires", "fullres", "detected", "aligned"}}

\item{unit}{Whether to use pixels in full resolution image or microns as the
unit. If using microns, then spacing between spots in pixels will be used
to convert the coordinates into microns, as the spacing is known to be 100
microns. This is used to plot scale bar.}

\item{style}{\code{style} can take values \dQuote{W}, \dQuote{B}, \dQuote{C}, \dQuote{U}, \dQuote{minmax} and \dQuote{S}}

\item{zero.policy}{default NULL, use global option value; if FALSE stop with error for any empty neighbour sets, if TRUE permit the weights list to be formed with zero-length weights vectors}

\item{load}{Deprecated. Not used, kept for backward compatibility for now.}

\item{row.names}{String specifying whether to use Ensembl IDs ("ID") or gene symbols ("Symbol") as row names. If using symbols, the Ensembl ID will be appended to disambiguate in case the same symbol corresponds to multiple Ensembl IDs.}

\item{flip}{Whether to flip the geometries or the images, because in
\code{sf} and \code{terra}, the geometries use the Cartesian coordinates
greater y coordinates going up, while in images, greater y values go down.
Originally the Visium spots are in pixels in full res image. Either the
image or the geometry needs to be flipped for them match in the Cartesian
coordinate system.}

\item{sample}{To be consistent with \code{SpatialExperiment::read10xVisium},
one or more directories with Space Ranger output for a Visium sample. It is
assumed to have the \code{outs} directory in it but this can be overridden
with the \code{dirs} argument.}
}
\value{
A SpatialFeatureExperiment object. The images might need to be
  manually transposed and/or mirrored to match the spots in this version of
  this package.
}
\description{
Read Space Ranger output from Visium v1 (not HD) as a
SpatialFeatureExperiment object, where spots are represented with polygons in
the colGeometry called "spotPoly". Other
geometries can be added later after the dataset is read. If \code{data =
"filtered"}, then spatial neighborhood graphs of the spots are also computed
and stored in the colGraph called "visium" in all samples for downstream
spatial analyses.
}
\note{
It is assumed that the images have not been cropped. Otherwise the
  images might not align with the spots.
}
\examples{
dir <- system.file("extdata", package = "SpatialFeatureExperiment")

sample_ids <- c("sample01", "sample02")
samples <- file.path(dir, sample_ids)

list.files(samples[1])
list.files(file.path(samples[1], "spatial"))
(sfe <- read10xVisiumSFE(samples, sample_id = sample_ids,
    type = "sparse", data = "filtered",
    load = FALSE
))

}
\concept{Read data into SFE}
