% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{rotateImg}
\alias{rotateImg}
\alias{rotateImg,SpatRasterImage-method}
\alias{rotateImg,BioFormatsImage-method}
\alias{rotateImg,ExtImage-method}
\title{Rotate image}
\usage{
\S4method{rotateImg}{SpatRasterImage}(x, degrees, maxcell = 1e+07, ...)

\S4method{rotateImg}{BioFormatsImage}(x, degrees, ...)

\S4method{rotateImg}{ExtImage}(x, degrees, ...)
}
\arguments{
\item{x}{An object of class \code{*Image} as implemented in this package.}

\item{degrees}{How many degrees to rotate. Positive number means clockwise
and negative number means counterclockwise.}

\item{maxcell}{Max number of pixels to load \code{SpatRasterImage} into
memory. The default 1e7 is chosen because this is the approximate number of
pixels in the medium resolution image at \code{resolution = 4L} in Xenium
OME-TIFF to make different methods of this function consistent.}

\item{...}{Ignored. It's there so different methods can all be passed to the
same \code{lapply} in the method for SFE objects. Some methods have extra
arguments.}
}
\value{
\code{SpatRasterImage} will be loaded into memory and converted to
  \code{ExtImage}. Otherwise \code{*Image} object of the same class.
}
\description{
As in \code{SpatialExperiment}, rotation here must be a multiple of 90
degrees.
}
\seealso{
Other image methods: 
\code{\link{SFE-image}},
\code{\link{affineImg}()},
\code{\link{cropImg}()},
\code{\link{dim,BioFormatsImage-method}},
\code{\link{ext}()},
\code{\link{imgRaster}()},
\code{\link{imgSource}()},
\code{\link{mirrorImg}()},
\code{\link{scaleImg}()},
\code{\link{translateImg}()},
\code{\link{transposeImg}()}
}
\concept{Image affine transformation}
\concept{image methods}
