% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{scaleImg}
\alias{scaleImg}
\alias{scaleImg,AlignedSpatialImage-method}
\title{Scale image}
\usage{
\S4method{scaleImg}{AlignedSpatialImage}(x, factor, ...)
}
\arguments{
\item{x}{An object of class \code{*Image} as implemented in this package.}

\item{factor}{Numeric, scaling factor.}

\item{...}{Ignored. It's there so different methods can all be passed to the
same \code{lapply} in the method for SFE objects. Some methods have extra
arguments.}
}
\value{
A \code{*Image} object of the same class that has been scaled. Behind
the scene, it's only the extent that has been changed and the images are not
changed. The center of the image is unchanged.
}
\description{
This function scales the image about its center. After scaling, the center
of the image is not shifted.
}
\seealso{
Other image methods: 
\code{\link{SFE-image}},
\code{\link{affineImg}()},
\code{\link{cropImg}()},
\code{\link{dim,BioFormatsImage-method}},
\code{\link{ext}()},
\code{\link{imgRaster}()},
\code{\link{imgSource}()},
\code{\link{mirrorImg}()},
\code{\link{rotateImg}()},
\code{\link{translateImg}()},
\code{\link{transposeImg}()}
}
\concept{Image affine transformation}
\concept{image methods}
