% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{transposeImg}
\alias{transposeImg}
\alias{transposeImg,SpatRasterImage-method}
\alias{transposeImg,BioFormatsImage-method}
\alias{transposeImg,ExtImage-method}
\title{Transpose images}
\usage{
\S4method{transposeImg}{SpatRasterImage}(x, filename = "", maxcell = NULL, ...)

\S4method{transposeImg}{BioFormatsImage}(x, ...)

\S4method{transposeImg}{ExtImage}(x, ...)
}
\arguments{
\item{x}{An object of class \code{*Image} as implemented in this package.}

\item{filename}{Output file name for transformed SpatRaster.}

\item{maxcell}{Max number of pixels to load \code{SpatRasterImage} into
memory. The default 1e7 is chosen because this is the approximate number of
pixels in the medium resolution image at \code{resolution = 4L} in Xenium
OME-TIFF to make different methods of this function consistent.}

\item{...}{Ignored. It's there so different methods can all be passed to the
same \code{lapply} in the method for SFE objects. Some methods have extra
arguments.}
}
\value{
For \code{SpatRasterImage} and \code{ExtImage}, object of the same
  class. For \code{BioFormatsImage}, the image of the specified resolution is
  read into memory and then the \code{ExtImage} method is called, returning
  \code{ExtImage}. For the extent: xmin and xmax are switched with ymin and
  ymax.
}
\description{
Swap rows and columns of images. In effect, this will flip the image around
the diagonal running from top left to bottom right.
}
\seealso{
Other image methods: 
\code{\link{SFE-image}},
\code{\link{affineImg}()},
\code{\link{cropImg}()},
\code{\link{dim,BioFormatsImage-method}},
\code{\link{ext}()},
\code{\link{imgRaster}()},
\code{\link{imgSource}()},
\code{\link{mirrorImg}()},
\code{\link{rotateImg}()},
\code{\link{scaleImg}()},
\code{\link{translateImg}()}
}
\concept{Image affine transformation}
\concept{image methods}
