% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{convert_id}
\alias{convert_id}
\title{convert_id}
\usage{
convert_id(
  org = NULL,
  name = "name",
  file = NULL,
  query_column = 1,
  convert_column = NULL,
  colon = TRUE,
  first_arg_comma = TRUE,
  remove_dot = TRUE,
  pref = NULL,
  sep = " ",
  first_arg_sep = TRUE,
  divide_semicolon = TRUE,
  edge = FALSE
)
}
\arguments{
\item{org}{which identifier to convert}

\item{name}{which column to convert in edge or node table}

\item{file}{specify the file for conversion.
The column in `query_column` will be used for querying the ID in the graph.}

\item{query_column}{default to 1.}

\item{convert_column}{which column is parsed in 
obtained data frame from KEGG REST API or local file}

\item{colon}{whether the original ids include colon (e.g. `ko:`)
If `NULL`, automatically set according to `org`}

\item{first_arg_comma}{take first argument of comma-separated
string, otherwise fetch all strings}

\item{remove_dot}{remove dots in the name}

\item{pref}{prefix for the query identifiers}

\item{sep}{separater to separate node names, defaul to space}

\item{first_arg_sep}{take first argument if multiple identifiers
are in the node name, otherwise parse all identifiers}

\item{divide_semicolon}{whether to divide string by semicolon,
and take the first value}

\item{edge}{if converting edges}
}
\value{
vector containing converted IDs
}
\description{
convert the identifier using retrieved information
}
\examples{
library(tidygraph)
graph <- create_test_pathway()
graph <- graph \%>\% mutate(conv=convert_id("hsa"))

}
