% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_functions.R
\name{module_completeness}
\alias{module_completeness}
\title{module_completeness}
\usage{
module_completeness(kmo, query, name = "1")
}
\arguments{
\item{kmo}{module object}

\item{query}{vector of KO}

\item{name}{name of definitions when multiple definitions are present}
}
\value{
tibble
}
\description{
This converts module definitions consisting of KO identifiers 
to the expression by converting `+` and ` ` to `AND`, and `,` to `OR`.
After that, KO IDs specified by `query` is inserted to expression 
by `TRUE` or `FALSE`, and is evaluated.
Please feel free to contact the bug, or modules that cannot be calculated.
(Module definitions consisting of module IDs [M*] cannot be calculated)
}
\details{
Below is quoted from https://www.genome.jp/kegg/module.html

`A space or a plus sign, representing a connection
in the pathway or the molecular complex,
is treated as an AND operator and a comma,
used for alternatives, is treated as an OR operator.
A minus sign designates an optional item in the complex.`
}
\examples{
## Assess completeness based on one KO input
test_complete <- module_completeness(create_test_module(), c("K00112"))
}
