% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_count_offtargets.R
\name{add_genome_matches}
\alias{add_genome_matches}
\title{Add genome matches}
\usage{
add_genome_matches(
  spacers,
  bsgenome = getBSgenome(genome(spacers)[1]),
  mismatches = 2,
  pam = "NGG",
  offtargetmethod = c("bowtie", "pdict")[1],
  outdir = OUTDIR,
  indexedgenomesdir = INDEXEDGENOMESDIR,
  verbose = TRUE
)
}
\arguments{
\item{spacers}{GRanges}

\item{bsgenome}{BSgenome}

\item{mismatches}{number}

\item{pam}{string}

\item{offtargetmethod}{'bowtie' or 'pdict'}

\item{outdir}{bowtie output directory}

\item{indexedgenomesdir}{directory with indexed genomes}

\item{verbose}{TRUE (default) or FALSE}
}
\value{
GRanges
}
\description{
Add genome matches
}
\examples{
require(magrittr)
file <- system.file('extdata/SRF.bed', package='multicrispr')
bsgenome <- BSgenome.Mmusculus.UCSC.mm10::BSgenome.Mmusculus.UCSC.mm10
targets0 <- bed_to_granges(file, 'mm10')
targets <- extend(targets0)
spacers <- find_spacers(targets, bsgenome, complement = FALSE, 
                        ontargetmethod = NULL, offtargetmethod = NULL)
spacers \%<>\% extract(1:100)
spacers \%<>\% add_genome_matches(bsgenome)
}
