% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_count_offtargets.R
\name{add_target_matches}
\alias{add_target_matches}
\title{Add target matches}
\usage{
add_target_matches(
  spacers,
  targets,
  bsgenome,
  mismatches = 2,
  pam = "NGG",
  outdir = OUTDIR,
  verbose = TRUE
)
}
\arguments{
\item{spacers}{GRanges}

\item{targets}{GRanges}

\item{bsgenome}{BSgenome}

\item{mismatches}{number}

\item{pam}{string}

\item{outdir}{bowtie output directory}

\item{verbose}{TRUE (default) or FALSE}
}
\value{
GRanges
}
\description{
Add target matches
}
\examples{
require(magrittr)
file <- system.file('extdata/SRF.bed', package='multicrispr')
bsgenome <- BSgenome.Mmusculus.UCSC.mm10::BSgenome.Mmusculus.UCSC.mm10
targets0 <- bed_to_granges(file, 'mm10')
targets <- extend(targets0)
spacers <- find_spacers(targets, bsgenome, complement = FALSE, 
                        ontargetmethod = NULL, offtargetmethod = NULL)
spacers \%<>\% add_target_matches(targets, bsgenome)
}
