% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_manipulate_ranges.R
\name{double_flank}
\alias{double_flank}
\title{Double flank}
\usage{
double_flank(
  gr,
  upstart = -200,
  upend = -1,
  downstart = 1,
  downend = 200,
  strandaware = TRUE,
  plot = FALSE,
  linetype_var = "set",
  ...
)
}
\arguments{
\item{gr}{\code{\link[GenomicRanges]{GRanges-class}}}

\item{upstart}{upstream flank start in relation to start(gr)}

\item{upend}{upstream flank end   in relation to start(gr)}

\item{downstart}{downstream flank start in relation to end(gr)}

\item{downend}{downstream flank end   in relation to end(gr)}

\item{strandaware}{TRUE (default) or FALSE}

\item{plot}{TRUE or FALSE (default)}

\item{linetype_var}{gr var mapped to linetype}

\item{...}{passed to plot_intervals}
}
\value{
\code{\link[GenomicRanges]{GRanges-class}}
}
\description{
Double flank
}
\examples{
# Prime Editing example
#----------------------
    require(magrittr)
    bsgenome <- BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38  
    gr <- char_to_granges(c(PRNP = 'chr20:4699600:+',             # snp
                            HBB  = 'chr11:5227002:-',             # snp
                            HEXA = 'chr15:72346580-72346583:-',   # del
                            CFTR = 'chr7:117559593-117559595:+'), # ins
                          bsgenome)
    double_flank(gr, -10,  -1, +1, +20, plot = TRUE)
      
# TFBS example
#-------------
    bedfile  <- system.file('extdata/SRF.bed', package='multicrispr')
    gr  <-  bed_to_granges(bedfile, genome = 'mm10', plot = FALSE)
    double_flank(gr, plot = TRUE)
}
