% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_score_ontargets.R
\name{score_ontargets}
\alias{score_ontargets}
\title{Add on-target efficiency scores}
\usage{
score_ontargets(
  spacers,
  bsgenome,
  ontargetmethod = c("Doench2014", "Doench2016")[1],
  chunksize = 10000,
  verbose = TRUE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{spacers}{\code{\link[GenomicRanges]{GRanges-class}}: spacers}

\item{bsgenome}{\code{\link[BSgenome]{BSgenome-class}}}

\item{ontargetmethod}{'Doench2014' (default) or 'Doench2016'
(requires non-NULL argument python, virtualenv, or condaenv)}

\item{chunksize}{Doench2016 is executed in chunks of chunksize}

\item{verbose}{TRUE (default) or FALSE}

\item{plot}{TRUE (default) or FALSE}

\item{...}{passed to \code{\link{plot_intervals}}}
}
\value{
numeric vector
}
\description{
Add Doench2014 or Doench2016 on-target efficiency scores
}
\details{
\code{add_ontargets} adds efficiency scores
\code{filter_ontargets} adds efficiency scores and filters on them
}
\examples{
# Install azimuth 
#----------------
    ## With reticulate
    # require(reticulate)
    # conda_create('azienv', c('python=2.7'))
    # use_condaenv('azienv')
    # py_install(c('azimuth', 'scikit-learn==0.17.1', 'biopython=='1.76'), 
    #            'azienv', pip = TRUE)
    
    ## Directly
    # conda create --name azienv python=2.7
    # conda activate azienv
    # pip install scikit-learn==0.17.1
    # pip install biopython==1.76
    # pip install azimuth
    
# PE example
#-----------
    require(magrittr)
    bsgenome <- BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38  
    targets <- char_to_granges(c(PRNP = 'chr20:4699600:+',             # snp
                                 HBB  = 'chr11:5227002:-',             # snp
                                 HEXA = 'chr15:72346580-72346583:-',   # del
                                 CFTR = 'chr7:117559593-117559595:+'), # ins
                               bsgenome)
    spacers <- find_primespacers(targets, bsgenome, ontargetmethod=NULL, 
                                offtargetmethod=NULL)
    spacers \%<>\% score_ontargets(bsgenome, 'Doench2014')
    # reticulate::use_condaenv('azienv')
    # reticulate::import('azimuth')
    # spacers \%<>\% score_ontargets(bsgenome, 'Doench2016')
    
# TFBS example
#-------------
    bedfile  <- system.file('extdata/SRF.bed', package = 'multicrispr')
    bsgenome <- BSgenome.Mmusculus.UCSC.mm10::BSgenome.Mmusculus.UCSC.mm10
    targets <- extend(bed_to_granges(bedfile, 'mm10'))
    spacers <- find_spacers(targets, bsgenome, ontargetmethod=NULL, 
                            offtargetmethod=NULL)
    spacers \%<>\% score_ontargets(bsgenome, 'Doench2014')
    # reticulate::use_condaenv('azienv')
    # reticulate::import('azimuth')
    # spacers \%>\%  score_ontargets(bsgenome, 'Doench2016')
}
\references{
Doench 2014, Rational design of highly active sgRNAs for 
CRISPR-Cas9-mediated gene inactivation. Nature Biotechnology,
doi: 10.1038/nbt.3026

Doench 2016, Optimized sgRNA design to maximize activity and minimize 
off-target effects of CRISPR-Cas9. Nature Biotechnology, 
doi: 10.1038/nbt.3437

Python module azimuth: github/MicrosoftResearch/azimuth
}
