## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    fig.path = 'figures/'
)

## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
library(Banksy)

library(data.table)
library(SummarizedExperiment)
library(SpatialExperiment)

library(scater)
library(cowplot)
library(ggplot2)

## ----eval=TRUE, echo=FALSE----------------------------------------------------
se <- readRDS(system.file("extdata/STARmap.rds", package = "Banksy"))

## ----eval=FALSE---------------------------------------------------------------
#  #' Change paths accordingly
#  gcm_path <- "../data/well11processed_expression_pd.csv.gz"
#  mdata_path <- "../data/well11_spatial.csv.gz"
#  
#  #' Gene cell matrix
#  gcm <- fread(gcm_path)
#  genes <- gcm$GENE
#  gcm <- as.matrix(gcm[, -1])
#  rownames(gcm) <- genes
#  
#  #' Spatial coordinates and metadata
#  mdata <- fread(mdata_path, skip = 1)
#  headers <- names(fread(mdata_path, nrows = 0))
#  colnames(mdata) <- headers
#  #' Orient spatial coordinates
#  xx <- mdata$X
#  yy <- mdata$Y
#  mdata$X <- max(yy) - yy
#  mdata$Y <- max(xx) - xx
#  mdata <- data.frame(mdata)
#  rownames(mdata) <- colnames(gcm)
#  
#  locs <- as.matrix(mdata[, c("X", "Y", "Z")])
#  
#  #' Create SpatialExperiment
#  se <- SpatialExperiment(
#      assay = list(processedExp = gcm),
#      spatialCoords = locs,
#      colData = mdata
#  )

## ----eval=FALSE---------------------------------------------------------------
#  lambda <- 0.8
#  k_geom <- 30
#  npcs <- 50
#  aname <- "processedExp"
#  se <- Banksy::computeBanksy(se, assay_name = aname, k_geom = k_geom)
#  
#  set.seed(1000)
#  se <- Banksy::runBanksyPCA(se, lambda = lambda, npcs = npcs)
#  
#  set.seed(1000)
#  se <- Banksy::clusterBanksy(se, lambda = lambda, npcs = npcs, resolution = 0.8)

## ----eval=TRUE----------------------------------------------------------------
head(colData(se))

## ----domain-segment-spatial, eval=FALSE, fig.height=8, fig.width=7, fig.align='center'----
#  cnames <- colnames(colData(se))
#  cnames <- cnames[grep("^clust", cnames)]
#  
#  plotColData(se, x = "X", y = "Y", point_size = 0.01, colour_by = cnames[1]) +
#      scale_color_manual(values = pals::glasbey()) +
#      coord_equal() +
#      theme(legend.position = "none")

## ----sess---------------------------------------------------------------------
sessionInfo()

