% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{connectClusters}
\alias{connectClusters}
\title{Relabel cluster labels across parameter runs to maximise their similarity.}
\usage{
connectClusters(se, map_to = NULL, verbose = TRUE)
}
\arguments{
\item{se}{A \code{SpatialExperiment},
\code{SingleCellExperiment} or \code{SummarizedExperiment}
  object with cluster labels in \code{colData(se)}.}

\item{map_to}{A string scalar specify a cluster to map to.}

\item{verbose}{A logical scalar specifying verbosity.}
}
\value{
A SpatialExperiment / SingleCellExperiment / SummarizedExperiment
  object with 'connected' cluster labels in \code{colData(se)}.
}
\description{
Relabel cluster labels across parameter runs to maximise their similarity.
}
\examples{
data(rings)
spe <- computeBanksy(rings, assay_name = "counts", M = 1, k_geom = c(15, 30))
spe <- runBanksyPCA(spe, M = 1, lambda = c(0, 0.2), npcs = 20)
spe <- clusterBanksy(spe, M = 1, lambda = c(0, 0.2), resolution = 1)
spe <- connectClusters(spe)

}
