% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{simulateDataset}
\alias{simulateDataset}
\title{Simulate an unrealistic spatial omics dataset.}
\usage{
simulateDataset(n_cells = 300, n_genes = 30, n_rings = 3, rate = 10)
}
\arguments{
\item{n_cells}{An integer scalar specifying the approximate number of cells.}

\item{n_genes}{An integer scalar specifying the number of genes.}

\item{n_rings}{An integer scalar specifying the number of spatial rings.}

\item{rate}{A numeric scalar specifying the Poisson rate parameter for
simulating counts.}
}
\value{
A SpatialExperiment object.
}
\description{
Simulate an unrealistic spatial omics dataset.
}
\details{
This function generates an unrealistic spatial omics dataset based on a 
user-specified number of cells and genes. The number of clusters is defined 
by \code{n_rings}, while counts follow a Poisson distribution with a 
user-specified rate \code{rate}. The simulation is set up such that the 
number of cells in each cluster is uniformly distributed; as such, the final 
number of cells is approximately equal to the user-specified number of cells.
}
\examples{
set.seed(2023)
rings <- simulateDataset(n_cells = 5e3, n_genes = 50, n_rings = 8)
rings
table(rings$cluster)
df <- cbind.data.frame(
    SummarizedExperiment::colData(rings), 
    SpatialExperiment::spatialCoords(rings))
library(ggplot2)
ggplot(df, aes(x=x, y=y, col=cluster)) + geom_point() + theme_classic()

}
