% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiocSet-methods.R
\name{BiocSet-methods}
\alias{BiocSet-methods}
\alias{es_activate}
\alias{filter.BiocSet}
\alias{select.BiocSet}
\alias{mutate.BiocSet}
\alias{summarise.BiocSet}
\alias{arrange.BiocSet}
\alias{.tbl_nongroup_vars.BiocSet}
\alias{group_by.BiocSet}
\alias{left_join.BiocSet}
\alias{as.list.BiocSet}
\alias{union.BiocSet}
\alias{intersect.BiocSet}
\title{BiocSet methods}
\usage{
es_activate(.data, what)

\method{filter}{BiocSet}(.data, ...)

\method{select}{BiocSet}(.data, ...)

\method{mutate}{BiocSet}(.data, ...)

\method{summarise}{BiocSet}(.data, ...)

\method{arrange}{BiocSet}(.data, ...)

.tbl_nongroup_vars.BiocSet(x)

\method{group_by}{BiocSet}(.data, ..., add = FALSE)

\method{left_join}{BiocSet}(x, y, by, copy, suffix, ...)

\method{as.list}{BiocSet}(x, ...)

\method{union}{BiocSet}(x, y, ...)

\method{intersect}{BiocSet}(x, y, ...)
}
\arguments{
\item{.data}{The \code{BiocSet} object.}

\item{what}{Which of the three tibbles from \code{BiocSet} to activate.}

\item{...}{Additional arguments passed to function.}

\item{x}{For \code{.tbl_nongroup_vars} (internal), a \code{BiocSet}
object. For \code{union} and \code{intersect} the first
\code{BiocSet} object to perform the operations on.}

\item{add}{logical, whether to add to the existing groups.}

\item{y}{For \code{left_join}, a tibble to join. For \code{union} and 
\code{intersect} the second \code{BiocSet} object used.}

\item{by}{A character vector of variables to join by.}

\item{copy}{logical, allows you to join tables across srcs.}

\item{suffix}{Character vector of length 2, if there are non-joined duplicate
variables in 'x' and 'y' these suffixes will be added to the output.}
}
\value{
A \code{BiocSet} object.
}
\description{
\code{es_activate}: which of the three tibbles in the
    \code{BiocSet} object should be activated and have the chosen
    functionality applied to it.

\code{filter}: choose rows where conditions are true.

\code{select}: keep only the variables listed.

\code{mutate}: add new variable and preserve the existing 
    variables.

\code{summarise}: usually used with \code{group_by()}, output 
    will have one row for each group.

\code{arrange}: order rows by an expression involving its 
    variables.

\code{.tbl_nongroup_vars}: returns only non-grouping variables.

\code{group_by}: converts an existing tbl into a grouped tbl.

\code{left_join}: returns all rows from \code{x}, and all 
    columns from \code{x} and \code{y}. If no rows in \code{x} match with 
    \code{y} there will be \code{NA}s in the new column. If there are 
    multiple matches then all combinations are returned.

\code{as.list}: coerces argument into a list.

\code{union}: combines all rows from two \code{BiocSet} objects
    and removes duplicate records from the combined \code{BiocSet} object.

\code{intersect}: combines all rows from two \code{BiocSet} 
    objects and returns rows that appear in both \code{BiocSet} objects.
}
\examples{
es <- BiocSet(set1 = letters, set2 = LETTERS)
es_activate(es, element)

es \%>\% es_activate(element) \%>\% filter(element == "a")

es \%>\% select(element)

es \%>\% es_activate(set) \%>\% mutate(pval = rnorm(1:2))

es \%>\% es_activate(set) \%>\% summarise(n = n())

es \%>\% es_activate(element) \%>\% arrange(desc(element))

es \%>\% mutate(pval = rnorm(1:52)) \%>\% es_elementset() \%>\%
    BiocSet:::.tbl_nongroup_vars()

es \%>\% group_by(element, set)

es <- BiocSet(set1 = letters[1:5], set2 = LETTERS[1:5])
tbl <- tibble(x = 1:10, y = c(letters[1:5], LETTERS[1:5]))
es \%>\% left_join(tbl, by = c(element = "y"))

library(org.Hs.eg.db)
es <- go_sets(org.Hs.eg.db, "ENSEMBL")
head(as.list(es))

es1 <- BiocSet(set1 = letters[c(1:4)], set2 = LETTERS[c(1:4)])
es2 <- BiocSet(set1 = letters[c(3:8)], set2 = LETTERS[c(3:8)])

dplyr::union(es1, es2)

dplyr::intersect(es1, es2)
}
\keyword{internal}
