% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-OBO.R
\name{obo_relations}
\alias{obo_relations}
\alias{oboset_element_children}
\alias{oboset_element_parents}
\alias{oboset_element_ancestors}
\alias{oboset_set_children}
\alias{oboset_set_parents}
\alias{oboset_set_ancestors}
\title{Functions to display relationships of an \code{OBOSet} object}
\usage{
oboset_element_children(oboset)

oboset_element_parents(oboset)

oboset_element_ancestors(oboset)

oboset_set_children(oboset)

oboset_set_parents(oboset)

oboset_set_ancestors(oboset)
}
\arguments{
\item{oboset}{The \code{OBOSet} of interest.}
}
\value{
A 2 column tibble.
}
\description{
These functions will display the relationships (children, 
    parents, or ancestors) for either the elements or the sets of an 
    \code{OBOSet} object.
}
\examples{
oboFile <- system.file("extdata", "sample_go.obo", package = "BiocSet")
obo <- import(oboFile)
oboset_element_children(obo) 

oboset_element_parents(obo)

oboset_element_ancestors(obo)

oboset_set_children(obo)

oboset_set_parents(obo)

oboset_set_ancestors(obo)
}
