% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{get_merged_mods}
\alias{get_merged_mods}
\alias{get_merged_mods,CEMiTool-method}
\title{Merge similar modules}
\usage{
get_merged_mods(cem, ...)

\S4method{get_merged_mods}{CEMiTool}(cem, mods, diss_thresh = 0.8, verbose = FALSE)
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}.}

\item{...}{Optional parameters.}

\item{mods}{A vector containing numeric labels for each module gene}

\item{diss_thresh}{A threshold of dissimilarity for modules. Default is 0.8.}

\item{verbose}{Logical. If \code{TRUE}, reports analysis steps. Default \code{FALSE}}
}
\value{
Numeric labels assigning genes to modules.
}
\description{
This function takes a CEMiTool object with expression and a vector of
numeric labels to merge similar modules.
}
\examples{
# Get example expression data
data(expr0)
# Initialize new CEMiTool object with expression data
cem <- new_cem(expr0, filter=TRUE, apply_vst=FALSE)
# Calculate adjacency matrix with example beta value 8
cem <- get_adj(cem, beta=8)
# Get modules
mods <- get_mods(cem)
# Merge similar modules
merged_mods <- get_merged_mods(cem, mods)

}
