% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cemitool.R
\name{new_cem}
\alias{new_cem}
\title{Create a CEMiTool object}
\usage{
new_cem(
  expr = data.frame(),
  sample_annot = data.frame(),
  sample_name_column = "SampleName",
  class_column = "Class",
  filter = TRUE,
  apply_vst = FALSE,
  filter_pval = 0.1
)
}
\arguments{
\item{expr}{Object of class \code{data.frame} with gene
expression data}

\item{sample_annot}{Object of \code{data.frame} containing the sample
annotation. It should have at least two columns containing group Class
and the Sample Name that should match with samples in
expression file}

\item{sample_name_column}{A string specifying the column to be used as
sample identification. Default: "SampleName".}

\item{class_column}{A string specifying the column to be used as
a grouping factor for samples. Default: "Class"}

\item{filter}{Logical. Used to define if posterior functions should use filtered
expression data or not (Default: TRUE)}

\item{apply_vst}{Logical. Used to define if posterior functions should use a
variance stabilizing transformation on expression data before analyses. Only
valid if argument \code{filter} is TRUE. (Default: FALSE)}

\item{filter_pval}{logical. Threshold for filter p-value. Ignored if
filter = FALSE (Default: 0.1)}
}
\value{
Object of class \code{CEMiTool}
}
\description{
Create a CEMiTool object
}
\examples{
# Create new CEMiTool object
cem <- new_cem()
# Create new CEMiTool object with expression and sample_annotation data
data(expr0)
data(sample_annot)
cem <- new_cem(expr0, sample_annot, "SampleName", "Class")
# Equivalent to a call to new()
cem2 <- new("CEMiTool", expression=expr0, sample_annotation=sample_annot)
identical(cem, cem2)
}
