% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplots.R
\name{ggplotMarginalDensities}
\alias{ggplotMarginalDensities}
\title{Plot of channel intensity marginal densities}
\usage{
ggplotMarginalDensities(
  x,
  sampleSubset,
  channels,
  pDataForColour,
  pDataForGroup,
  nEventInSubsample = Inf,
  seed = NULL,
  transList
)
}
\arguments{
\item{x}{a \code{flowCore::flowSet} (or a single \code{flowCore::flowFrame})}

\item{sampleSubset}{(optional) a logical vector, of size \code{nrow(pData)},
which is by construction the nb of samples, indicating which samples to keep
in the plot. Typically it is obtained through the evaluation of
a logical condition on \code{pData} rows.}

\item{channels}{(optional)}

\item{pDataForColour}{(optional) which \code{phenoData(fs)} variable
will be used as colour aesthetic. Should be a character.}

\item{pDataForGroup}{(optional) which \code{phenoData(fs)} variable
will be used as group aesthetic. Should be a character.}

\item{nEventInSubsample}{how many event to take
(per flowFrame of the flowSet).}

\item{seed}{if not null, used in subsampling.}

\item{transList}{a \code{flowCore::transformList} that will be applied
before plotting.}
}
\value{
a ggplot object
}
\description{
\code{ggplotMarginalDensities} uses ggplot2
to draw plots of marginal densities of selected channels of a flowSet.
If the flowSet contains several flowFrames, all events are concatenated
together.
By default, a pseudo Rsquare projection quality indicator,
and the number of dimensions of the MDS projection are provided in sub-title
}
\examples{

library(CytoPipeline)

data(OMIP021Samples)

# estimate scale transformations 
# and transform the whole OMIP021Samples

transList <- estimateScaleTransforms(
    ff = OMIP021Samples[[1]],
    fluoMethod = "estimateLogicle",
    scatterMethod = "linearQuantile",
    scatterRefMarker = "BV785 - CD3")

OMIP021Trans <- CytoPipeline::applyScaleTransforms(
    OMIP021Samples, 
    transList)
    

# As there are only 2 samples in OMIP021Samples dataset,
# we create artificial samples that are random combinations of both samples

ffList <- c(
    flowCore::flowSet_to_list(OMIP021Trans),
    lapply(3:5,
           FUN = function(i) {
               aggregateAndSample(
                   OMIP021Trans,
                   seed = 10*i,
                   nTotalEvents = 5000)[,1:22]
           }))

fsNames <- c("Donor1", "Donor2", paste0("Agg",1:3))
names(ffList) <- fsNames

fsAll <- as(ffList,"flowSet")

flowCore::pData(fsAll)$grpId <- factor(c("D1", "D2", rep("Agg", 3)))
flowCore::pData(fsAll)$lbl <- paste0("S", 1:5)

# plot densities, all samples together
p <- ggplotMarginalDensities(fsAll)

# plot densities, per sample
p <- ggplotMarginalDensities(fsAll, pDataForGroup = "lbl")

# plot densities, per sample and coloured by group
p <- ggplotMarginalDensities(
    fsAll, 
    pDataForGroup = "lbl",
    pDataForColour = "grpId")

}
