% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{pairwiseEMDDist}
\alias{pairwiseEMDDist}
\title{Pairwise Earth Mover's Distance calculation}
\usage{
pairwiseEMDDist(
  x,
  rowRange = c(1, nSamples),
  colRange = c(min(rowRange), nSamples),
  loadExprMatrixFUN = NULL,
  loadExprMatrixFUNArgs = NULL,
  channels = NULL,
  verbose = FALSE,
  BPPARAM = BiocParallel::SerialParam(),
  BPOPTIONS = BiocParallel::bpoptions(packages = c("flowCore")),
  binSize = 0.05,
  minRange = -10,
  maxRange = 10
)
}
\arguments{
\item{x}{can be:
\itemize{
\item a flowCore::flowSet
\item a list of expression matrices (Double matrix with named columns)
\item the number of samples (integer >=1)
}}

\item{rowRange}{the range of rows of the distance matrix to be calculated}

\item{colRange}{the range of columns of the distance matrix to be calculated}

\item{loadExprMatrixFUN}{the function used to translate an integer index
into an expression matrix. In other words, the function should code how to
load the \code{index}th expression matrix into memory.
IMPORTANT: the expression matrix index should be the first function argument
and should be named \code{exprMatrixIndex}.}

\item{loadExprMatrixFUNArgs}{(optional) a named list containing
additional input parameters of \code{loadExprMatrixFUN()}}

\item{channels}{which channels (integer index(ices) or character(s)):
\itemize{
\item if it is a character vector,
it can refer to either the channel names, or the marker names
\item if it is a numeric vector,
it refers to the indexes of channels in \code{fs}
\item if NULL all scatter and fluorescent channels of \code{fs} #' will be selected
}}

\item{verbose}{if \code{TRUE}, output a message
after each single distance calculation}

\item{BPPARAM}{sets the \code{BPPARAM} back-end to
be used for the computation. If not provided, will use
\code{BiocParallel::SerialParam()} (no task parallelization)}

\item{BPOPTIONS}{sets the BPOPTIONS to be
passed to \code{bplapply()} function.
Note that if you use a \code{SnowParams} back-end, you need to specify all
the packages that need to be loaded for the different CytoProcessingStep
to work properly (visibility of functions). As a minimum,
the \code{flowCore} package needs to be loaded.
(hence the default \code{BPOPTIONS = bpoptions(packages = c("flowCore"))} )}

\item{binSize}{size of equal bins to approximate
the marginal distributions.}

\item{minRange}{minimum value taken
when approximating the marginal distributions}

\item{maxRange}{maximum value taken
when approximating the marginal distributions}
}
\value{
a distance matrix of pairwise distances
(full symmetric with 0. diagonal)
}
\description{
Computation of all EMD between pairs of flowFrames belonging
to a flowSet.
This method provides three different input modes:
\itemize{
\item the user provides directly a flowCore::flowSet loaded in memory (RAM).
\item the user provides directly a list of expression matrices loaded in RAM,
of which the column names are the channel/marker names
\item the user provides (1.) a number of samples \code{nSamples}; (2.) an ad-hoc
function that takes as input an index between 1 and \code{nSamples}, and codes
the method to load the corresponding expression matrix in memory;
Optional row and column ranges can be provided to limit the calculation
to a specific rectangle of the matrix. These i.e. can be specified as a way
to split heavy calculations of large distance matrices
on several computation nodes.
}
}
\examples{

library(CytoPipeline)

data(OMIP021Samples)

# estimate scale transformations
# and transform the whole OMIP021Samples

transList <- estimateScaleTransforms(
    ff = OMIP021Samples[[1]],
    fluoMethod = "estimateLogicle",
    scatterMethod = "linearQuantile",
    scatterRefMarker = "BV785 - CD3")

OMIP021Trans <- CytoPipeline::applyScaleTransforms(
    OMIP021Samples,
    transList)

# calculate pairwise distances using only FSC-A & SSC-A channels
pwDist <- pairwiseEMDDist(
    x = OMIP021Trans,
    channels = c("FSC-A", "SSC-A"))

}
