% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R
\name{reducedDims<-}
\alias{reducedDims<-}
\title{reducedDims<-}
\usage{
reducedDims(x, subsetName) <- value
}
\arguments{
\item{x}{Input \code{ExperimentSubset} object or any object supported by \code{reducedDims<-} from \link[SingleCellExperiment]{reducedDims} method.}

\item{subsetName}{Specify the name of the subset to which the \code{reducedDims} should be set to. If \code{missing}, \code{reducedDims<-} from \link[SingleCellExperiment]{reducedDims} method is called on the main object.}

\item{value}{A \code{list} of values to set to \code{reducedDims}.}
}
\value{
Updated input object with \code{reducedDims} set.
}
\description{
A wrapper to the \code{reducedDims<-} from \link[SingleCellExperiment]{reducedDims} method with additional support for subsets.
}
\examples{
data(sce_chcl, package = "scds")
es <- ExperimentSubset(sce_chcl)
es <- createSubset(es, "subset1",
rows = c(1:1500), cols = c(1:1500),
parentAssay = "counts")
reducedDims(es, subsetName = "subset1") <- list(
PCA_1 = scater::calculatePCA(assay(es, "subset1")),
PCA_2 = scater::calculatePCA(assay(es, "subset1")))
reducedDims(es, subsetName = "subset1")
}
