\name{GenerateExample}
\alias{GenerateExample}
\title{Generate example input data}
\description{
  Generate input data which can be used as an example.
}
\usage{
GenerateExample(dimA, dimB, filling, covariance, symmetric = FALSE,
numOrths = 0, correlated = NA, distribution = "normal")
}
\arguments{
  \item{dimA}{size of network A}
  \item{dimB}{size of network B}
  \item{filling}{fraction of entries which are not explicitly set to zero}
  \item{covariance}{covariance of correlated rows and columns}
  \item{symmetric}{generate symmetric matrices}
  \item{numOrths}{number of diagonal elements to set to 1 in example matrix R}
  \item{correlated}{indices of correlated rows and columns}
  \item{distribution}{from which distribution are the values drawn ("normal" or "uniform")}
}
\value{
  The return value is a list containing example matrices A (a), B (b) and R (r).
}
\details{
Symmetric example matrices A, B can be generated by specifying TRUE as
the 'symmetric' argument. If the 'numOrths' argument is specified, a
number of diagonal elements of R equal to the value will be set to 1. If
a vector is specified as the 'correlated' argument, the specified rows
and columns will be set to correlated values. Leaving this argument
blank will result in pairwise correlations of all entries in A, B (or, if the matrices are of different rank, all elements of the smaller on will be correlated with the corresponding parts of the larger matrix).
}
\examples{
ex <- GenerateExample(dimA = 170, dimB = 140, filling = 0.75,
                      covariance = 0.4, symmetric = TRUE, numOrths = 90,
                      correlated = 1:90, distribution = "normal")

##-- edge weight correlation
image(cor(ex$a[1:140, 1:140], ex$b))
hist(diag(cor(ex$a[1:140, 1:140], ex$b))[1:90])

##-- edge weight distribution
hist(ex$a[ex$a != 0]);
hist(ex$b[ex$b != 0]);
}
\author{Joern P. Meier, Michal Kolar, Ville Mustonen, Michael Laessig, and Johannes Berg}
\keyword{misc}
