% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmbreps.R
\name{cmbreps}
\alias{cmbreps}
\title{cmbreps}
\usage{
cmbreps(
  ifiles = list(),
  method = c("fisher", "max", "mean"),
  outputfile = character(),
  outdir = ".",
  log = TRUE,
  verbose = 2L
)
}
\arguments{
\item{ifiles}{MACS score in bedGraph for each replicate. Require at
least 2 files such as '-i A B C D'. REQUIRED}

\item{method}{to use while combining scores from replicates. 1)
fisher: Fisher's combined probability test. It requires scores
in ppois form (-log10 pvalues) from bdgcmp. Other types of
scores for this method may cause cmbreps unexpected errors. 2)
max: take the maximum value from replicates for each genomic
position. 3) mean: take the average value. Note, except for
Fisher's method, max or mean will take scores AS IS which means
they won't convert scores from log scale to linear scale or
vice versa.", default="fisher"}

\item{outputfile}{Output BEDGraph filename for combined scores.}

\item{outdir}{The output directory.}

\item{log}{Whether to capture logs.}

\item{verbose}{Set verbose level of runtime message. 0: only show
critical message, 1: show additional warning message, 2: show
process information, 3: show debug messages. DEFAULT:2}
}
\value{
\code{macsList} object.
}
\description{
Combine BEDGraphs of scores from replicates. Note: All regions on
the same chromosome in the bedGraph file should be continuous so
only bedGraph files from MACS3 are accpetable.
}
\examples{
eh <- ExperimentHub::ExperimentHub()
CHIP <- eh[["EH4558"]]
CTRL <- eh[["EH4563"]]
c1 <- callpeak(CHIP, CTRL, gsize = 5.2e7, cutoff_analysis = TRUE,
               outdir = tempdir(), name = "callpeak_narrow0",
               store_bdg = TRUE)
cmbreps(ifiles = list(c1$outputs[1], c1$outputs[7]),
        method = "max", outdir = tempdir(), outputfile = "cmbreps")
}
