% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_visualizations.R
\name{shinyMsQuality}
\alias{shinyMsQuality}
\title{Shiny application to visualize quality metrics}
\usage{
shinyMsQuality(qc)
}
\arguments{
\item{qc}{\code{matrix}, contains the calculated quality metrics, the columns
contain the metrics and the rows the samples}
}
\value{
\code{shiny}
}
\description{
The function \code{shinyMsQuality} function starts a shiny application to 
visualize the quality metrics interactively. It allows to display all metrics
contained in \code{qc}. 

The function accepts the output of \code{calculateMetrics},
\code{calculateMetricsFromSpectra}, or \code{calculateMetricsFromMsExperiment}
}
\details{
The plots within the shiny application can be saved by clicking on the 
download button.
}
\examples{
library(msdata)
library(MsExperiment)
library(S4Vectors)
msexp <- MsExperiment()
sd <- DataFrame(sample_id = c("QC1", "QC2"),
    sample_name = c("QC Pool", "QC Pool"), injection_idx = c(1, 3))
sampleData(msexp) <- sd

## define file names containing spectra data for the samples and
## add them, along with other arbitrary files to the experiment
fls <- dir(system.file("sciex", package = "msdata"), full.names = TRUE)
experimentFiles(msexp) <- MsExperimentFiles(
    mzML_files = fls,
    annotations = "internal_standards.txt")
## link samples to data files: first sample to first file in "mzML_files",
## second sample to second file in "mzML_files"
msexp <- linkSampleData(msexp, with = "experimentFiles.mzML_files",
    sampleIndex = c(1, 2), withIndex = c(1, 2))
msexp <- linkSampleData(msexp, with = "experimentFiles.annotations",
    sampleIndex = c(1, 2), withIndex = c(1, 1))

library(Spectra)
## import the data and add it to the mse object
spectra(msexp) <- Spectra(fls, backend = MsBackendMzR())

## define the quality metrics to be calculated
metrics <- c("areaUnderTic", "chromatographyDuration", "msSignal10xChange")
    
## calculate the metrics
## additional parameters passed to the quality metrics functions
## (msLevel is an argument of areaUnderTic and msSignal10xChange,
## relativeTo is an argument of msSignal10xChange)
qc <- calculateMetricsFromMsExperiment(msexp = msexp, metrics = metrics, 
    msLevel = 1, relativeTo = "Q1", change = "jump")
rownames(qc) <- c("Sample 1", "Sample 2")

if (interactive())
    shinyMsQuality(qc = qc)

}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
