% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Study.R
\name{setImmPortDataSource}
\alias{setImmPortDataSource}
\title{Set ImmPort data ource}
\usage{
setImmPortDataSource(data_src)
}
\arguments{
\item{data_src}{A connection handle to ImmPort (MySQL or SQLite) database instance or 
a directory handle to folder where study RImmPort-formatted (.rds) files located}
}
\value{
1 if successful
}
\description{
The function \code{setImmPortDataSource} sets the data source variable in RImmPort environment, 
to the connection handle to the MySQL or SQLite database, or to the file directory where the 
pre-created RImmPort-formatted files are stored.
}
\examples{
library(DBI)
library(sqldf)
studies_dir <- system.file("extdata", "ImmPortStudies", package = "RImmPort")
db_dir <- file.path(studies_dir, "Db")
sqlite_conn <- dbConnect(SQLite(), dbname=file.path(db_dir, "ImmPort.sqlite"))
setImmPortDataSource(sqlite_conn)
}

