% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modifier-Inosine-class.R,
%   R/Modifier-Inosine-viz.R
\name{ModInosine-functions}
\alias{ModInosine-functions}
\alias{settings<-,ModInosine-method}
\alias{aggregateData,ModInosine-method}
\alias{findMod,ModInosine-method}
\alias{getDataTrack,ModInosine-method}
\alias{plotDataByCoord,ModInosine,GRanges-method}
\alias{plotData,ModInosine-method}
\alias{plotDataByCoord,ModSetInosine,GRanges-method}
\alias{plotData,ModSetInosine-method}
\title{Functions for ModInosine}
\usage{
\S4method{settings}{ModInosine}(x) <- value

\S4method{aggregateData}{ModInosine}(x)

\S4method{findMod}{ModInosine}(x)

\S4method{getDataTrack}{ModInosine}(x, name, type, ...)

\S4method{plotDataByCoord}{ModInosine,GRanges}(x, coord, type = "score", window.size = 15L, ...)

\S4method{plotData}{ModInosine}(x, name, from = 1L, to = 30L, type = "score", ...)

\S4method{plotDataByCoord}{ModSetInosine,GRanges}(x, coord, type = "score", window.size = 15L, ...)

\S4method{plotData}{ModSetInosine}(x, name, from = 1L, to = 30L, type = "score", ...)
}
\arguments{
\item{x}{a \code{\link[RNAmodR:Modifier-class]{Modifier}} or a 
\code{\link[RNAmodR:ModifierSet-class]{ModifierSet}} object. For more details
see also the man pages for the functions mentioned below.}

\item{value}{See \code{\link[RNAmodR:Modifier-functions]{settings}}}

\item{coord, name, from, to, type, window.size, ...}{See 
\code{\link{plotData}}}
}
\value{
\itemize{
\item{\code{settings}} {See \code{\link[=Modifier-functions]{settings}}.}
\item{\code{aggregate}} {See \code{\link{aggregate}}.}
\item{\code{modify}} {See \code{\link{modify}}.}
\item{\code{getDataTrack}} {a list of 
\code{\link[Gviz:DataTrack-class]{DataTrack}} objects. See 
\code{\link{plotDataByCoord}}.}
\item{\code{plotData}} {See \code{\link{plotDataByCoord}}.}
\item{\code{plotDataByCoord}} {See \code{\link{plotDataByCoord}}.}
}
}
\description{
All of the functions of \code{\link[RNAmodR:Modifier-class]{Modifier}} and
the \code{\link[RNAmodR:ModifierSet-class]{ModifierSet}} classes are 
inherited by the \code{ModInosine} and \code{ModSetInosine} classes.

Check below for the specifically implemented functions.
}
\details{
\code{ModInosine} specific arguments for \link{plotData}:
\itemize{
\item{\code{colour.bases} - }{a named character vector of \code{length = 4} 
for the colours of the individual bases. The names are expected to be 
\code{c("G","A","U","C")}}
}
}
\examples{
data(msi,package="RNAmodR")
mi <- msi[[1]]
settings(mi)
\dontrun{
aggregate(mi)
modify(mi)
}
getDataTrack(mi, "1", mainScore(mi))
}
