% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNAmodR.R, R/AllGenerics.R, R/Modifier-utils.R,
%   R/SequenceData-class.R
\docType{class}
\name{RNAmodR-development}
\alias{RNAmodR-development}
\alias{getData}
\alias{constructModRanges}
\alias{constructModRanges,GRanges,DataFrame-method}
\title{RNAmodR developments functions}
\usage{
constructModRanges(range, data, modType, scoreFun, source, type)

getData(x, bamfiles, grl, sequences, param, args)

\S4method{constructModRanges}{GRanges,DataFrame}(range, data, modType, scoreFun, source, type)
}
\arguments{
\item{range}{for \code{constructModRanges}: a \code{GRanges} object}

\item{data}{for \code{constructModRanges}: a \code{DataFrame} object}

\item{modType}{for \code{constructModRanges}: a valid shortName for the 
modification found. Must be present in \code{shortName(ModRNAString())}.}

\item{scoreFun}{for \code{constructModRanges}: a custom function for 
extracting scores from \code{data}. The result must be a \code{list}.}

\item{source}{for \code{constructModRanges}: a single character vector for
populating the source column of the result.}

\item{type}{for \code{constructModRanges}: a single character vector for
populating the source column of the result.}

\item{x}{for \code{getData}:a \code{SequenceData} object.}

\item{bamfiles}{for \code{getData}:a \code{BamFileList} object.}

\item{grl}{for \code{getData}:a \code{GRangesList} object.}

\item{sequences}{for \code{getData}:a \code{XStringSet} object.}

\item{param}{for \code{getData}:a \code{ScanBamParam} object.}

\item{args}{for \code{getData}: a \code{list} with optional arguments.}
}
\value{
\itemize{
\item{\code{getData}:} {returns a list with elements per BamFile in 
\code{bamfiles}. Elements can be 
\code{\link[IRanges:AtomicList-class]{IntegerList}}, 
\code{\link[IRanges:AtomicList-class]{NumericList}} or a
\code{\link[IRanges:DataFrameList-class]{CompressedSplitDataFrameList}}. The
data in the elements must be order by increasing positions numbers. However, 
names and rownames will be discarded.}
\item{\code{constructModRanges}:} {returns a \code{GRanges} object with
genomic coordinates of modified nucleotides in the associated transcripts.}
}
}
\description{
These functions are not intended for general use, but are used for 
additional package development. 

\code{getData} is used to load data into a
\code{\link[RNAmodR:SequenceData-class]{SequenceData}} object and must be
implented for all \code{SequenceData} classes. The results must match the
requirements outlined in the value section.

In addition the following functions should be implemented for complete
functionality:

\code{aggregateData} for each \code{SequenceData} and \code{Modifier} class.
See also \code{\link[=aggregate]{aggregateData}}

\code{findMod} for each \code{Modifier} class. See also 
\code{\link[=modify]{findMod}}.

\code{plotData}/\code{plotDataByCoord} for each \code{Modifier} 
and \code{ModifierSet} class. See also 
\code{\link[=plotData]{plotData}}.

The following helper function can be called from within \code{findMod} to
construct a coordinate for each modification found:

\code{constructModRanges} constructs a \code{GRanges} object describing the
location, type and associated scores of a modification.
\code{constructModRanges} is typically called from the \code{modify}
function, which must be implemented for all
\code{\link[RNAmodR:Modifier-class]{Modifier}} classes.
}
\examples{
# new SequenceData class
setClass(Class = "ExampleSequenceData",
         contains = "SequenceData",
         prototype = list(minQuality = 5L))
ExampleSequenceData <- function(bamfiles, annotation, sequences, seqinfo, ...){
  RNAmodR:::SequenceData("Example", bamfiles = bamfiles, 
                         annotation = annotation, sequences = sequences,
                         seqinfo = seqinfo, ...)
}
setMethod("getData",
          signature = c(x = "ExampleSequenceData",
                        bamfiles = "BamFileList",
                        grl = "GRangesList",
                        sequences = "XStringSet",
                        param = "ScanBamParam"),
          definition = function(x, bamfiles, grl, sequences, param, args){
            ###
          }
)
setMethod("aggregateData",
          signature = c(x = "ExampleSequenceData"),
          function(x, condition = c("Both","Treated","Control")){
            ###
          }
)
setMethod(
  f = "getDataTrack",
  signature = c(x = "ExampleSequenceData"),
  definition = function(x, name, ...) {
    ###
  }
)

# new Modifier class
setClass("ModExample",
         contains = "Modifier",
         prototype = list(mod = "X",
                          score = "score",
                          dataType = "ExampleSequenceData"))
ModExample <- function(x, annotation, sequences, seqinfo, ...){
  RNAmodR:::Modifier("ModExample", x = x, annotation = annotation,
                     sequences = sequences, seqinfo = seqinfo, ...)
}

setMethod(f = "aggregateData",
          signature = c(x = "ModExample"),
          definition =
            function(x, force = FALSE){
              # Some data with element per transcript
            }
)

setMethod("findMod",
          signature = c(x = "ModExample"),
          function(x){
            # an element per modification found.
          }
)
setMethod(
  f = "getDataTrack",
  signature = signature(x = "ModExample"),
  definition = function(x, name, type, ...) {
  }
)
setMethod(
  f = "plotDataByCoord",
  signature = signature(x = "ModExample", coord = "GRanges"),
  definition = function(x, coord, type = "score", window.size = 15L, ...) {
  }
)
setMethod(
  f = "plotData",
  signature = signature(x = "ModExample"),
  definition = function(x, name, from, to, type = "score", ...) {
  }
)
 
# new ModifierSet class
setClass("ModSetExample",
         contains = "ModifierSet",
         prototype = list(elementType = "ModExample"))
ModSetExample <- function(x, annotation, sequences, seqinfo, ...){
  RNAmodR:::ModifierSet("ModExample", x = x, annotation = annotation,
                        sequences = sequences, seqinfo = seqinfo, ...)
}

setMethod(
  f = "plotDataByCoord",
  signature = signature(x = "ModSetExample", coord = "GRanges"),
  definition = function(x, coord, type = "score", window.size = 15L, ...) {
  }
)
setMethod(
  f = "plotData",
  signature = signature(x = "ModSetExample"),
  definition = function(x, name, from, to, type = "score", ...) {
  }
)
}
