% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SequenceDataFrame-class.R,
%   R/SequenceData-class.R, R/SequenceDataSet-class.R,
%   R/SequenceDataList-class.R
\name{SequenceData-functions}
\alias{SequenceData-functions}
\alias{replicates}
\alias{show,SequenceDataFrame-method}
\alias{conditions,SequenceDataFrame-method}
\alias{bamfiles,SequenceDataFrame-method}
\alias{dataType,SequenceDataFrame-method}
\alias{ranges,SequenceDataFrame-method}
\alias{replicates,SequenceDataFrame-method}
\alias{seqinfo,SequenceDataFrame-method}
\alias{seqtype,SequenceDataFrame-method}
\alias{seqtype<-,SequenceDataFrame-method}
\alias{sequences,SequenceDataFrame-method}
\alias{show,SequenceData-method}
\alias{getData,SequenceData,BamFileList,GRangesList,XStringSet,ScanBamParam-method}
\alias{bamfiles,SequenceData-method}
\alias{conditions,SequenceData-method}
\alias{ranges,SequenceData-method}
\alias{replicates,SequenceData-method}
\alias{seqinfo,SequenceData-method}
\alias{sequences,SequenceData-method}
\alias{seqtype,SequenceData-method}
\alias{seqtype<-,SequenceData-method}
\alias{dataType,SequenceData-method}
\alias{show,SequenceDataSet-method}
\alias{bamfiles,SequenceDataSet-method}
\alias{conditions,SequenceDataSet-method}
\alias{names,SequenceDataSet-method}
\alias{ranges,SequenceDataSet-method}
\alias{replicates,SequenceDataSet-method}
\alias{seqinfo,SequenceDataSet-method}
\alias{seqtype,SequenceDataSet-method}
\alias{seqtype<-,SequenceDataSet-method}
\alias{sequences,SequenceDataSet-method}
\alias{show,SequenceDataList-method}
\alias{bamfiles,SequenceDataList-method}
\alias{conditions,SequenceDataList-method}
\alias{names,SequenceDataList-method}
\alias{ranges,SequenceDataList-method}
\alias{replicates,SequenceDataList-method}
\alias{seqinfo,SequenceDataList-method}
\alias{seqtype,SequenceDataList-method}
\alias{seqtype<-,SequenceDataList-method}
\alias{sequences,SequenceDataList-method}
\title{SequenceData/SequenceDataSet/SequenceDataList/SequenceDataFrame 
functions}
\usage{
replicates(x)

\S4method{show}{SequenceDataFrame}(object)

\S4method{conditions}{SequenceDataFrame}(object)

\S4method{bamfiles}{SequenceDataFrame}(x)

\S4method{dataType}{SequenceDataFrame}(x)

\S4method{ranges}{SequenceDataFrame}(x)

\S4method{replicates}{SequenceDataFrame}(x)

\S4method{seqinfo}{SequenceDataFrame}(x)

\S4method{seqinfo}{SequenceDataFrame}(x)

\S4method{seqtype}{SequenceDataFrame}(x)

\S4method{seqtype}{SequenceDataFrame}(x) <- value

\S4method{sequences}{SequenceDataFrame}(x)

\S4method{show}{SequenceData}(object)

\S4method{getData}{SequenceData,BamFileList,GRangesList,XStringSet,ScanBamParam}(x, bamfiles, grl, sequences, param, args)

\S4method{bamfiles}{SequenceData}(x)

\S4method{conditions}{SequenceData}(object)

\S4method{ranges}{SequenceData}(x)

\S4method{replicates}{SequenceData}(x)

\S4method{seqinfo}{SequenceData}(x)

\S4method{sequences}{SequenceData}(x)

\S4method{seqtype}{SequenceData}(x)

\S4method{seqtype}{SequenceData}(x) <- value

\S4method{dataType}{SequenceData}(x)

\S4method{show}{SequenceDataSet}(object)

\S4method{bamfiles}{SequenceDataSet}(x)

\S4method{conditions}{SequenceDataSet}(object)

\S4method{names}{SequenceDataSet}(x)

\S4method{ranges}{SequenceDataSet}(x)

\S4method{replicates}{SequenceDataSet}(x)

\S4method{seqinfo}{SequenceDataSet}(x)

\S4method{seqtype}{SequenceDataSet}(x)

\S4method{seqtype}{SequenceDataSet}(x) <- value

\S4method{sequences}{SequenceDataSet}(x)

\S4method{show}{SequenceDataList}(object)

\S4method{bamfiles}{SequenceDataList}(x)

\S4method{conditions}{SequenceDataList}(object)

\S4method{names}{SequenceDataList}(x)

\S4method{ranges}{SequenceDataList}(x)

\S4method{replicates}{SequenceDataList}(x)

\S4method{seqinfo}{SequenceDataList}(x)

\S4method{seqtype}{SequenceDataList}(x)

\S4method{seqtype}{SequenceDataList}(x) <- value

\S4method{sequences}{SequenceDataList}(x)
}
\arguments{
\item{x, object}{a \code{SequenceData}, \code{SequenceDataSet}, 
\code{SequenceDataList} or a \code{SequenceDataFrame} object.}

\item{value}{a new \code{seqtype}, either "RNA" or "DNA"}

\item{bamfiles}{a \code{BamFileList}.}

\item{grl}{a \code{GRangesList} from \code{exonsBy(..., by = "tx")}}

\item{sequences}{a \code{XStringSet} of type \code{RNAStringSet}, 
\code{ModRNAStringSet}, \code{DNAStringSet} or 
\code{ModDNAStringSet}}

\item{param}{a \code{\link[Rsamtools:ScanBamParam-class]{ScanBamParam}} 
object}

\item{args}{a list of addition arguments}
}
\value{
\itemize{
\item{\code{seqinfo}:} {a \code{Seqinfo} object ().}
\item{\code{sequences}:} {a \code{RNAStingSet} object or a \code{RNAString} 
object for a \code{SequenceDataFrame}.}
\item{\code{ranges}:} {a \code{GRangesList} object with each element per 
transcript or a \code{GRanges} object for a \code{SequenceDataFrame}.}
\item{\code{bamfiles}:} {a \code{BamFileList} object or a SimpleList of 
\code{BamFileList} objects for a \code{SequenceDataList}.}
}
}
\description{
The \code{SequenceData}, \code{SequenceDataSet}, \code{SequenceDataList} and
\code{SequenceDataFrame} classes share functionality. Have a look at the 
elements listed directly below.
}
\examples{
data(e5sd,package="RNAmodR")
# general accessors
seqinfo(e5sd)
sequences(e5sd)
ranges(e5sd)
bamfiles(e5sd)
}
