% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gviz-ModifiedSequenceTrack-class.R
\docType{class}
\name{SequenceModDNAStringSetTrack-class}
\alias{SequenceModDNAStringSetTrack-class}
\alias{ModDNASequenceTrack}
\alias{SequenceModDNAStringSetTrack}
\alias{seqnames,SequenceModDNAStringSetTrack-method}
\alias{seqlevels,SequenceModDNAStringSetTrack-method}
\title{ModDNASequenceTrack}
\usage{
ModDNASequenceTrack(sequence, chromosome, genome, name = "SequenceTrack", ...)

\S4method{seqnames}{SequenceModDNAStringSetTrack}(x)

\S4method{seqlevels}{SequenceModDNAStringSetTrack}(x)
}
\arguments{
\item{sequence}{A \code{character} vector or \code{ModDNAString} object of 
length one. The sequence to display. See 
\code{\link[Gviz:SequenceTrack-class]{SequenceTrack}}.}

\item{chromosome, genome, name, ...}{See 
\code{\link[Gviz:SequenceTrack-class]{SequenceTrack}}.}

\item{x}{A \code{SequenceModDNAStringSetTrack} object.}
}
\value{
a \code{SequenceModDNAStringSetTrack} object
}
\description{
A \code{Gviz} compatible 
\code{\link[Gviz:SequenceTrack-class]{SequenceTrack}} for showing modified 
DNA sequences.
}
\section{Slots}{

\describe{
\item{\code{sequence}}{A \code{ModDNAStringSet} object}
}}

\examples{
seq <- ModDNAStringSet(c(chr1 = paste0(alphabet(ModDNAString()),
                                       collapse = "")))
st <- ModDNASequenceTrack(seq)
Gviz::plotTracks(st, chromosome = "chr1",from = 1L, to = 20L)
}
