% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gviz-ModifiedSequenceTrack-class.R
\docType{class}
\name{SequenceModRNAStringSetTrack-class}
\alias{SequenceModRNAStringSetTrack-class}
\alias{ModRNASequenceTrack}
\alias{SequenceModRNAStringSetTrack}
\alias{seqnames,SequenceModRNAStringSetTrack-method}
\alias{seqlevels,SequenceModRNAStringSetTrack-method}
\title{ModRNASequenceTrack}
\usage{
ModRNASequenceTrack(sequence, chromosome, genome, name = "SequenceTrack", ...)

\S4method{seqnames}{SequenceModRNAStringSetTrack}(x)

\S4method{seqlevels}{SequenceModRNAStringSetTrack}(x)
}
\arguments{
\item{sequence}{A \code{character} vector or \code{ModRNAString} object of 
length one. The sequence to display. See 
\code{\link[Gviz:SequenceTrack-class]{SequenceTrack}}.}

\item{chromosome, genome, name, ...}{See 
\code{\link[Gviz:SequenceTrack-class]{SequenceTrack}}.}

\item{x}{A \code{SequenceModRNAStringSetTrack} object.}
}
\value{
a \code{SequenceModRNAStringSetTrack} object
}
\description{
A \code{Gviz} compatible 
\code{\link[Gviz:SequenceTrack-class]{SequenceTrack}} for showing modified 
RNA sequences.
}
\section{Slots}{

\describe{
\item{\code{sequence}}{A \code{ModRNAStringSet} object}
}}

\examples{
seq <- ModRNAStringSet(c(chr1 = paste0(alphabet(ModRNAString()),
                                       collapse = "")))
st <- ModRNASequenceTrack(seq)
Gviz::plotTracks(st, chromosome = "chr1",from = 1L, to = 20L)
}
