% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ModifierSet-comparison.R
\name{compare}
\alias{compare}
\alias{compareByCoord}
\alias{plotCompare}
\alias{plotCompareByCoord}
\alias{compare,ModifierSet-method}
\alias{compareByCoord,ModifierSet,GRanges-method}
\alias{compareByCoord,ModifierSet,GRangesList-method}
\alias{plotCompare,ModifierSet-method}
\alias{plotCompareByCoord,ModifierSet,GRanges-method}
\alias{plotCompareByCoord,ModifierSet,GRangesList-method}
\title{Comparison of Samples}
\usage{
compare(x, name, pos = 1L, ...)

compareByCoord(x, coord, ...)

plotCompare(x, name, pos = 1L, normalize, ...)

plotCompareByCoord(x, coord, normalize, ...)

\S4method{compare}{ModifierSet}(x, name, pos = 1L, normalize, ...)

\S4method{compareByCoord}{ModifierSet,GRanges}(x, coord, normalize, ...)

\S4method{compareByCoord}{ModifierSet,GRangesList}(x, coord, normalize, ...)

\S4method{plotCompare}{ModifierSet}(x, name, pos = 1L, normalize, ...)

\S4method{plotCompareByCoord}{ModifierSet,GRanges}(x, coord, normalize, ...)

\S4method{plotCompareByCoord}{ModifierSet,GRangesList}(x, coord, normalize, ...)
}
\arguments{
\item{x}{a \code{Modifier} or \code{ModifierSet} object.}

\item{name}{Only for \code{compare}: the transcript name}

\item{pos}{Only for \code{compare}: pos for comparison}

\item{...}{optional parameters:
\itemize{
\item{\code{alias}} {a data.frame with two columns, \code{tx_id} and 
\code{name}, to convert transcipt ids to another identifier}
\item{\code{name}} {Limit results to one specific gene or transcript}
\item{\code{sequenceData}} {TRUE or FALSE? Should the aggregate of 
sequenceData be used for the comparison instead of the aggregate data if each
\code{Modifier} element? (default: \code{sequenceData = FALSE})}
\item{\code{compareType}} {a valid score type to use for the comparison. If
\code{sequenceData = FALSE} this defaults to \code{mainScore(x)}, whereas
if \code{sequenceData = TRUE} all columns will be used by setting 
\code{allTypes = TRUE}.}
\item{\code{allTypes}} {TRUE or FALSE? Should all available score be 
compared? (default: \code{allTypes = sequenceData})}
\item{...} {passed on to \code{\link{subsetByCoord}}}
}}

\item{coord}{coordinates of position to subset to. Either a \code{GRanges} or
a \code{GRangesList} object. For both types the 'Parent' column is expected
to match the transcript name. The \code{GRangesList} object is
unlisted and only non duplicated entries are retained.}

\item{normalize}{either a single logical or character value. If it is a 
character, it must match one of the names in the \code{ModifierSet}.}
}
\value{
\code{compareByCoord} returns a
  \code{\link[S4Vectors:DataFrame-class]{DataFrame}} and
  \code{plotCompareByCoord} returns a \code{ggplot} object, which can be
  modified further. The \code{DataFrame} contains columns per sample as well
  as the columns \code{names}, \code{positions} and \code{mod} incorporated
  from the \code{coord} input. If \code{coord} contains a column
  \code{Activity} this is included in the results as well.
}
\description{
To compare data of different samples, a
\code{\link[=ModifierSet-class]{ModifierSet}} can be used. To select the data
alongside the transcripts and their positions a
\code{\link[GenomicRanges:GRanges-class]{GRanges}} or a
\code{\link[GenomicRanges:GRanges-class]{GRangesList}} needs to be provided.
In case of a \code{GRanges} object, the parent column must match the
transcript names as defined by the out put of \code{ranges(x)}, whereas in
case of a \code{GRangesList} the element names must match the transcript
names.
}
\examples{
data(msi,package="RNAmodR")
# constructing a GRanges obejct to mark positive positions
mod <- modifications(msi)
coord <- unique(unlist(mod))
coord$score <- NULL
coord$sd <- NULL
# return a DataFrame
compareByCoord(msi,coord)
# plot the comparison as a heatmap
plotCompareByCoord(msi,coord)
}
