% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Modifier-viz.R,
%   R/ModifierSet-viz.R, R/SequenceData-viz.R, R/SequenceDataList-viz.R,
%   R/SequenceDataSet-viz.R
\name{plotData}
\alias{plotData}
\alias{plotDataByCoord}
\alias{getDataTrack}
\alias{plotDataByCoord,Modifier,GRanges-method}
\alias{plotData,Modifier-method}
\alias{getDataTrack,Modifier-method}
\alias{plotDataByCoord,ModifierSet,GRanges-method}
\alias{plotData,ModifierSet-method}
\alias{plotDataByCoord,SequenceData,GRanges-method}
\alias{plotData,SequenceData-method}
\alias{getDataTrack,SequenceData-method}
\alias{getDataTrack,SequenceDataList-method}
\alias{plotDataByCoord,SequenceDataList,GRanges-method}
\alias{plotData,SequenceDataList-method}
\alias{getDataTrack,SequenceDataSet-method}
\alias{plotDataByCoord,SequenceDataSet,GRanges-method}
\alias{plotData,SequenceDataSet-method}
\title{Visualizing data data from a \code{SequenceData}, 
\code{SequenceDataSet}, \code{SequenceDataList}, \code{Modifier} or 
\code{ModifierSet} object.}
\usage{
plotData(x, name, from = 1L, to = 30L, type, ...)

plotDataByCoord(x, coord, type, window.size = 15L, ...)

getDataTrack(x, name, ...)

\S4method{plotDataByCoord}{Modifier,GRanges}(x, coord, type = NA, window.size = 15L, ...)

\S4method{plotData}{Modifier}(
  x,
  name,
  from,
  to,
  type = NA,
  showSequenceData = FALSE,
  showSequence = TRUE,
  showAnnotation = FALSE,
  ...
)

\S4method{getDataTrack}{Modifier}(x, name = name, ...)

\S4method{plotDataByCoord}{ModifierSet,GRanges}(x, coord, type = NA, window.size = 15L, ...)

\S4method{plotData}{ModifierSet}(
  x,
  name,
  from,
  to,
  type = NA,
  showSequenceData = FALSE,
  showSequence = TRUE,
  showAnnotation = FALSE,
  ...
)

\S4method{plotDataByCoord}{SequenceData,GRanges}(x, coord, type = NA, window.size = 15L, ...)

\S4method{plotData}{SequenceData}(
  x,
  name,
  from,
  to,
  perTranscript = FALSE,
  showSequence = TRUE,
  showAnnotation = FALSE,
  ...
)

\S4method{getDataTrack}{SequenceData}(x, name = name, ...)

\S4method{getDataTrack}{SequenceDataList}(x, name = name, ...)

\S4method{plotDataByCoord}{SequenceDataList,GRanges}(x, coord, type = NA, window.size = 15L, ...)

\S4method{plotData}{SequenceDataList}(
  x,
  name,
  from,
  to,
  perTranscript = FALSE,
  showSequence = TRUE,
  showAnnotation = FALSE,
  ...
)

\S4method{getDataTrack}{SequenceDataSet}(x, name = name, ...)

\S4method{plotDataByCoord}{SequenceDataSet,GRanges}(x, coord, type = NA, window.size = 15L, ...)

\S4method{plotData}{SequenceDataSet}(
  x,
  name,
  from,
  to,
  perTranscript = FALSE,
  showSequence = TRUE,
  showAnnotation = FALSE,
  ...
)
}
\arguments{
\item{x}{a \code{SequenceData}, \code{SequenceDataSet},
\code{SequenceDataList}, \code{Modifier} or \code{ModifierSet} object.}

\item{name}{Only for \code{plotData}: the transcript name}

\item{from}{Only for \code{plotData}: start position}

\item{to}{Only for \code{plotData}: end position}

\item{type}{the data type of data show as data tracks.}

\item{...}{optional parameters:
\itemize{
\item{\code{modified.seq}} {\code{TRUE} or \code{FALSE}. Should the sequence 
shown with modified nucleotide positions? (default: 
\code{modified.seq = FALSE})}
\item{\code{additional.mod}} {other modifications, which should be shown
in the annotation and sequence track. The must be a \code{GRanges} compatible
with \code{\link[Modstrings:separate]{combineIntoModstrings}}.}
\item{\code{annotation.track.pars}} {Parameters passed onto the 
\code{\link[Gviz:AnnotationTrack-class]{AnnotationTrack}}.}
\item{\code{sequence.track.pars}} {Parameters passed onto the 
\code{\link[Gviz:SequenceTrack-class]{SequenceTrack}}.}
}}

\item{coord}{coordinates of a positions to subset to as a 
\code{GRanges} object. The 'Parent' column is expected to match the 
transcript name.}

\item{window.size}{integer value for the number of positions on the left and 
right site of the selected positions included in the plotting (default: 
\code{window.size = 15L})}

\item{showSequenceData}{\code{TRUE} or \code{FALSE}: should the sequence data
be shown? (default: \code{seqdata = FALSE})}

\item{showSequence}{\code{TRUE} or \code{FALSE}: should a sequence track be 
shown? (default: \code{seqdata = TRUE})}

\item{showAnnotation}{\code{TRUE} or \code{FALSE}: should a annotation track 
be shown? (default: \code{seqdata = FALSE})}

\item{perTranscript}{\code{TRUE} or \code{FALSE}: Should the positions shown
per transcript? (default: \code{perTranscript = FALSE})}
}
\value{
a plot send to the active graphic device
}
\description{
With the \code{plotData} and \code{plotDataByCoord} functions data
from a \code{SequenceData}, \code{SequenceDataSet}, \code{SequenceDataList},
\code{Modifier} or \code{ModifierSet} object can be visualized.

Internally the functionality of the \code{Gviz} package is used. For each
\code{SequenceData} and \code{Modifier} class the \code{getDataTrack} is
implemented returning a \code{\link[Gviz:DataTrack-class]{DataTrack}} object
from the \code{Gviz} package.

Positions to be visualized are selected by defining a genomic coordinate,
for which \code{x} has to contain data.
}
\examples{
data(msi,package="RNAmodR")
plotData(msi[[1]], "2", from = 10L, to = 45L)
\dontrun{
plotData(msi, "2", from = 10L, to = 45L)
}
}
