\name{tni.annotate.regulons}
\alias{tni.annotate.regulons}

\title{
Annotate regulons with external gene set collections.
}

\description{
This function calculates an enrichment score between gene sets and regulons.
}

\usage{
tni.annotate.regulons(object, geneSetList, sampleSetList = NULL, 
regulatoryElements = NULL, minSetSize = 15, sizeFilterMethod="posORneg", 
exponent = 1, verbose = TRUE)
}

\arguments{

\item{object}{
a preprocessed object of class 'TNI' \code{\link[RTN:TNI-class]{TNI-class}} 
already evaluated by the \code{\link[RTN:tni.dpi.filter]{tni.dpi.filter}} 
method.
}
\item{geneSetList}{
a list with gene sets.
}
\item{sampleSetList}{
an optional list with sample sets. The 'sampleSetList' should list numerical or 
integer vectors, with '0s' and '1s', which are used to split samples into
two groups. This option overrides the 'geneSetList' parameter (see Details).
}
\item{regulatoryElements}{
a vector of valid regulatory elements (e.g. transcription factors).
}
\item{minSetSize}{
a single integer or numeric value specifying the minimum number of 
elements in a gene set that must map to elements of the gene universe. 
Gene sets with fewer than this number are removed from the analysis.
}
\item{sizeFilterMethod}{
a single character value specifying the use of the 'minSetSize' argument, which is applyed to regulon's positive and negative targets. Options: "posANDneg", "posORneg", "posPLUSneg". For "posANDneg", the number of both positive and negative targets should be > 'minSetSize'; for "posORneg", the number of either positive or negative targets should be > 'minRegulonSize'; and for "posPLUSneg", the number of all targets should be > 'minSetSize'.
}
\item{exponent}{
a single integer or numeric value used in weighting phenotypes in GSEA
(this parameter only affects the 'dES' option).
}
\item{verbose}{
a single logical value specifying to display detailed messages (when 
verbose=TRUE) or not (when verbose=FALSE).
}
}

\details{
Using the samples available in the provided TNI object, the 'tni.annotate.regulons' calculates the enrichment of each regulon for each gene set. First, the samples are split into two groups, one with high average gene-set expression (GS_high) and the other with low average gene-set expression (GS_low). Then a gene-wise differential expression (DEG) signature is generated by comparing the GS_high vs. GS_low groups. The DEG signature is regarded as the gene-set phenotype in the cohort. A GSEA-2T approach is used to calculate the activity score (dES) of each regulon in the phenotype (for additional details on GSEA-2T, please see section 2.2 of the RTN's vignette).
}

\value{
A numeric matrix with dES scores between gene sets vs. regulons.
}

\author{Mauro Castro}

\seealso{
\code{\link[RTN:TNI-class]{TNI-class}}
}

\examples{

data(tniData)

\dontrun{

#compute regulons
rtni <- tni.constructor(expData=tniData$expData, 
        regulatoryElements=c("PTTG1","E2F2","FOXM1","E2F3","RUNX2"), 
        rowAnnotation=tniData$rowAnnotation)
rtni <- tni.permutation(rtni)
rtni <- tni.bootstrap(rtni)
rtni <- tni.dpi.filter(rtni)

#load a gene set collection 
#here, we build three random gene sets for demonstration
geneset1 <- sample(tniData$rowAnnotation$SYMBOL,50)
geneset2 <- sample(tniData$rowAnnotation$SYMBOL,50)
geneset3 <- sample(tniData$rowAnnotation$SYMBOL,50)
geneSetList <- list(geneset1=geneset1,
                    geneset2=geneset2,
                    geneset3=geneset3)

#compute regulon activity
dES <- tni.annotate.regulons(rtni, geneSetList)

}

}

\keyword{annotate}
