% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{formatFromBSseq}
\alias{formatFromBSseq}
\title{Parsing output from the BSseq package}
\usage{
formatFromBSseq(bsseq_dat, verbose = TRUE)
}
\arguments{
\item{bsseq_dat}{an object of class BSseq.}

\item{verbose}{logical indicates the level of information provided by the
algorithm during the process. The default value is TRUE.}
}
\value{
This function returns a \code{list} of \code{data.frame}s (one per
chromosome). Each \code{data.frame} contains rows as individual CpGs
appearing in all the samples. The first 4 columns contain the information of
\code{Meth_Counts} (methylated counts), \code{Total_Counts} (read depths),
\code{Position} (Genomic position for the CpG site) and \code{ID} (sample ID).
The additional information (such as disease status, sex, age) extracted from
the BSseq object are listed in column 5 and onwards and will be considered
as covariate information by SOMNiBUS algorithms.
}
\description{
This function reads and converts a BSseq object into a
\code{list} of \code{data.frame}s (one per chromosome) to a format compatible
with SOMNiBUS' main functions \code{runSOMNiBUS} and
\code{binomRegMethModel}.
}
\examples{
M <- matrix(1:9, 3,3)
colnames(M) <- c("A1", "A2", "A3")
BStest <- bsseq::BSseq(pos = 1:3, chr = c("chr1", "chr2", "chr1"), 
M = M, Cov = M + 2)
dat <- formatFromBSseq(BStest, verbose = FALSE)
}
\seealso{
\link[bsseq]{BSseq} for the BSseq class.

Other Parsing functions: 
\code{\link{formatFromBSmooth}()},
\code{\link{formatFromBismark}()}
}
\author{
Audrey Lemaçon
}
\concept{Parsing functions}
