% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrajectoryGeometry.R
\name{findSphericalDistance}
\alias{findSphericalDistance}
\title{Find the spherical distance from a given point to a
set of points.}
\usage{
findSphericalDistance(center, points, normalize = FALSE)
}
\arguments{
\item{center}{- The proposed point from which distance to
the others should be measured.  This is a numerical vector
of length d.}

\item{points}{- The set of target points for which spherical
distance to the center should be calculated.  This is in the
form of a n x d matrix.}

\item{normalize}{- If this is set to TRUE, the function will start
by normalizing the input points.}
}
\value{
This returns a vector of n spherical distances in
radians.
}
\description{
This function takes a point (typically a center) and
a set of points and finds the spherical distance between
the given point and each of the others.  If requested, it
will first normalize all of them.
}
\examples{
distances = findSphericalDistance(straight_path_center,
    straight_path_projection)
}
