% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrajectoryGeometry.R
\name{pathProgression}
\alias{pathProgression}
\title{Measure a path's progression}
\usage{
pathProgression(path, from = 1, to = nrow(path), d = ncol(path), direction)
}
\arguments{
\item{path}{- An n x d matrix}

\item{from}{- The point along the path to be taken as the starting
point.  This defaults to 1.}

\item{to}{- The point along the path to be used as the end point.
This defaults to nrow(path).}

\item{d}{- The dimension to be used.  This defaults to ncol(path).}

\item{direction}{- A non-zero numeric whose length is the the
dimension.}
}
\value{
This returns a numeric given the signed distance projection
    of the path along the line through its starting point in the
    given direction.
}
\description{
This function measures the progress of a path in a specified
direction.  This direction will typically be the center of its
projection onto the sphere as revealed using your favorite
statistic.
}
\examples{
progress =
    pathProgression(straight_path,direction=straight_path_center)
progress =
    pathProgression(crooked_path,from=6,direction=crooked_path_center)
}
