% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_bio_var.R
\name{aggregateBioVar}
\alias{aggregateBioVar}
\title{Aggregate subject-level biological variation}
\usage{
aggregateBioVar(scExp, subjectVar, cellVar)
}
\arguments{
\item{scExp}{\linkS4class{SingleCellExperiment} object containing
(at minimum) gene counts and column metadata describing sample identifiers
and cell types.}

\item{subjectVar}{Metadata column name assigning biological sample
identity to aggregate within-subject feature counts.}

\item{cellVar}{Metadata column name assigning cell type. Used for
aggregating gene-by-subject count matrices by cell type.}
}
\value{
List of \linkS4class{SummarizedExperiment} objects with
gene-by-subject count matrices and variable inter-subject column
metadata across and within cell types.
}
\description{
Given an input gene-by-cell count matrix from a
\linkS4class{SingleCellExperiment} object, sum within-subject gene counts
into an aggregate gene-by-subject count matrix. Column metadata accessed
by \link[SummarizedExperiment:SummarizedExperiment-class]{colData}
are collated by \link{subjectMetaData} to remove variables with inter-cell
intrasubject variation, effectively retaining between-subject variation.
The summary operations are performed across all cell types and within each
cell type. A list of \linkS4class{SummarizedExperiment} objects is returned
each with aggregate gene-by-subject count matrix and inter-subject metadata.
}
\examples{
## Aggregate gene-by-subject count matrix and inter-subject metadata
aggregateBioVar(
    scExp=small_airway,
    subjectVar="orig.ident", cellVar="celltype"
)

}
