% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_counts.R
\name{summarizedCounts}
\alias{summarizedCounts}
\title{Aggregate feature counts and metadata by subject}
\usage{
summarizedCounts(scExp, subjectVar)
}
\arguments{
\item{scExp}{\linkS4class{SingleCellExperiment} object containing
(at minimum) gene counts and column metadata describing sample identifiers
and cell types.}

\item{subjectVar}{Metadata column name assigning biological sample
identity to aggregate within-subject feature counts.}
}
\value{
\linkS4class{SummarizedExperiment} object with feature counts
aggregated by subject and summarized inter-subject metadata.
}
\description{
Given an input sparse count matrix and corresponding column metadata,
aggregate gene counts by subject level. Metadata variables with only
inter-subject variation are retained; any variables with cell-level variation
within a subject are dropped (e.g. feature / RNA count by cell).
}
\examples{
## Construct SummarizedExperiment object with gene-by-subject count matrix
## and column metadata summarized to exclude intrasubject variation.
## See `SummarizedExperiment` accessor functions `assay()` and `colData()`
## to access the count matrix and column metadata for downstream analyses.
summarizedCounts(scExp=small_airway, subjectVar="orig.ident")

}
