\name{BASHCompact}
\alias{BASHCompact}
\title{BASH - Compact Defect Analysis}
\description{
Creates a list of probes marked as being in compact defects.
}
\usage{
BASHCompact(inten, probeIDs, neighbours = NULL, wts=1, n=3, maxiter = 10,
        cutoff = 8,  cinvasions = 10, outlierFun=illuminaOutlierMethod, ...)
}

\arguments{
  \item{inten}{the (transformed) intensities associated with beads on an array.}
  \item{probeIDs}{the probe identities associated with those beads (i.e. indicating which beads are of which sort)}
  \item{neighbours}{A Neighbours matrix such as that generated by \code{\link{generateNeighbours}}. Compulsory - the function will no longer generate this for you.}
  \item{wts}{weights indicating any beads to be masked in calculations.}
  \item{n}{Specify a cut-off for outliers (e.g. as n median absolute deviations (MADs) from the median). The default value is 3}
  \item{maxiter}{Integer - Maximum number of iterations.}
  \item{cutoff}{Integer - Size a cluster must be to be labelled a compact defect.}
  \item{cinvasions}{Integer - Number of invasions used when closing the image.}
  \item{outlierFun}{the choice of outlier calling function to use.}
  \item{...}{Additional arguments to be passed to \code{outmeth}.}
}

\details{
	\code{BASHCompact} finds "compact defects" on an array. A compact defect is defined as a large connected cluster of outliers.

	This function first finds the outliers on an array. This is done via the user's choice of function (e.g. \code{\link{illuminaOutlierMethod}} or \code{\link{squeezedVarOutlierMethod}}.

	Next, using the Neighbours matrix and a Flood Fill algorithm, it determines which beads are in large connected clusters of outliers (of size larger than \code{cutoff}). These beads are then temporarily removed and the process repeated with the remaining beads. The repetition continues until either no large clusters of outliers remain, or until we have repeated the process \code{maxiter} times (and in this case, a warning will be given). In this way, we obtain a list of defective probes.

	Finally, we "close" the image, to fill in small gaps in the defect image. This consists of a "dilation" and an "erosion". In the dilation, we expand the defect image, by adding beads adjacent to defective beads into the defect image. This is repeated \code{cinvasions} times. In the erosion, we contract the defect image, by removing beads adjacent to non-defective beads from the defect image. (Erosion of the defect image is equivalent to a dilation of the non-defective image.)
}

\value{
A vector consisting of the BeadIDs of beads labelled as compact defects.
}

\author{Jonathan Cairns}

\seealso{\code{\link{BASH}}, \code{\link{generateNeighbours}} }

\examples{

\dontrun{

if(require(beadarrayExampleData)){

data(exampleBLData)
o <- BASHCompact(getBeadData(exampleBLData,array=1,what="Grn"), 
                 getBeadData(exampleBLData,array=1,what="ProbeIDs"))
##increased no of closure invasions
o <- BASHCompact(getBeadData(exampleBLData,array=1,what="Grn"), 
                 getBeadData(exampleBLData,array=1,what="ProbeIDs"), cinvasions = 10) 
##only larger defects will be found with this setting
o <- BASHCompact(getBeadData(exampleBLData,array=1,what="Grn"), 
                    getBeadData(exampleBLData,array=1,what="ProbeIDs"), cutoff = 12) 

}

}
}

\references{
	J. M. Cairns, M. J. Dunning, M. E. Ritchie, R. Russell, and A. G. Lynch (2008). BASH: a tool for managing BeadArray spatial artefacts. Bioinformatics 15; 24(24)

}
\keyword{misc}
